/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.platform.client;

import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.apache.maven.shared.utils.StringUtils;

public class Request<T> {
    private final Method method;
    private final String path;
    private final Class<T> result;
    private final Object jsonBody;
    private final File multipartBody;
    private final String multipartName;

    public static Request<Map> Get(String path) {
        return Request.builder().method(Method.GET).path(path).result(Map.class).build();
    }

    public static Request<Map> Delete(String path) {
        return Request.builder().method(Method.DELETE).path(path).result(Map.class).build();
    }

    public static Request<Map> Post(String path) {
        return Request.builder().method(Method.POST).path(path).result(Map.class).build();
    }

    public Request<T> withUrlParam(String key, Object value) {
        return this.withPath(StringUtils.replace((String)this.path, (String)key, (String)String.valueOf(value)));
    }

    public <S> Request<S> withResponse(Class<S> clazz) {
        return new Request<S>(this.method, this.path, clazz, this.jsonBody, this.multipartBody, this.multipartName);
    }

    @Generated
    Request(Method method, String path, Class<T> result, Object jsonBody, File multipartBody, String multipartName) {
        this.method = method;
        this.path = path;
        this.result = result;
        this.jsonBody = jsonBody;
        this.multipartBody = multipartBody;
        this.multipartName = multipartName;
    }

    @Generated
    public static <T> RequestBuilder<T> builder() {
        return new RequestBuilder();
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Class<T> getResult() {
        return this.result;
    }

    @Generated
    public Object getJsonBody() {
        return this.jsonBody;
    }

    @Generated
    public File getMultipartBody() {
        return this.multipartBody;
    }

    @Generated
    public String getMultipartName() {
        return this.multipartName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Class<T> this$result = this.getResult();
        Class<T> other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Object this$jsonBody = this.getJsonBody();
        Object other$jsonBody = other.getJsonBody();
        if (this$jsonBody == null ? other$jsonBody != null : !this$jsonBody.equals(other$jsonBody)) {
            return false;
        }
        File this$multipartBody = this.getMultipartBody();
        File other$multipartBody = other.getMultipartBody();
        if (this$multipartBody == null ? other$multipartBody != null : !((Object)this$multipartBody).equals(other$multipartBody)) {
            return false;
        }
        String this$multipartName = this.getMultipartName();
        String other$multipartName = other.getMultipartName();
        return !(this$multipartName == null ? other$multipartName != null : !this$multipartName.equals(other$multipartName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Class<T> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Object $jsonBody = this.getJsonBody();
        result = result * 59 + ($jsonBody == null ? 43 : $jsonBody.hashCode());
        File $multipartBody = this.getMultipartBody();
        result = result * 59 + ($multipartBody == null ? 43 : ((Object)$multipartBody).hashCode());
        String $multipartName = this.getMultipartName();
        result = result * 59 + ($multipartName == null ? 43 : $multipartName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Request(method=" + this.getMethod() + ", path=" + this.getPath() + ", result=" + this.getResult() + ", jsonBody=" + this.getJsonBody() + ", multipartBody=" + this.getMultipartBody() + ", multipartName=" + this.getMultipartName() + ")";
    }

    @Generated
    public Request<T> withMethod(Method method) {
        return this.method == method ? this : new Request<T>(method, this.path, this.result, this.jsonBody, this.multipartBody, this.multipartName);
    }

    @Generated
    public Request<T> withPath(String path) {
        return this.path == path ? this : new Request<T>(this.method, path, this.result, this.jsonBody, this.multipartBody, this.multipartName);
    }

    @Generated
    public Request<T> withResult(Class<T> result) {
        return this.result == result ? this : new Request<T>(this.method, this.path, result, this.jsonBody, this.multipartBody, this.multipartName);
    }

    @Generated
    public Request<T> withJsonBody(Object jsonBody) {
        return this.jsonBody == jsonBody ? this : new Request<T>(this.method, this.path, this.result, jsonBody, this.multipartBody, this.multipartName);
    }

    @Generated
    public Request<T> withMultipartBody(File multipartBody) {
        return this.multipartBody == multipartBody ? this : new Request<T>(this.method, this.path, this.result, this.jsonBody, multipartBody, this.multipartName);
    }

    @Generated
    public Request<T> withMultipartName(String multipartName) {
        return this.multipartName == multipartName ? this : new Request<T>(this.method, this.path, this.result, this.jsonBody, this.multipartBody, multipartName);
    }

    @Generated
    public static class RequestBuilder<T> {
        @Generated
        private Method method;
        @Generated
        private String path;
        @Generated
        private Class<T> result;
        @Generated
        private Object jsonBody;
        @Generated
        private File multipartBody;
        @Generated
        private String multipartName;

        @Generated
        RequestBuilder() {
        }

        @Generated
        public RequestBuilder<T> method(Method method) {
            this.method = method;
            return this;
        }

        @Generated
        public RequestBuilder<T> path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public RequestBuilder<T> result(Class<T> result) {
            this.result = result;
            return this;
        }

        @Generated
        public RequestBuilder<T> jsonBody(Object jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        @Generated
        public RequestBuilder<T> multipartBody(File multipartBody) {
            this.multipartBody = multipartBody;
            return this;
        }

        @Generated
        public RequestBuilder<T> multipartName(String multipartName) {
            this.multipartName = multipartName;
            return this;
        }

        @Generated
        public Request<T> build() {
            return new Request<T>(this.method, this.path, this.result, this.jsonBody, this.multipartBody, this.multipartName);
        }

        @Generated
        public String toString() {
            return "Request.RequestBuilder(method=" + this.method + ", path=" + this.path + ", result=" + this.result + ", jsonBody=" + this.jsonBody + ", multipartBody=" + this.multipartBody + ", multipartName=" + this.multipartName + ")";
        }
    }

    public static enum Method {
        GET,
        POST,
        DELETE;

    }
}

