/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.platform;

import com.cumulocity.agent.packaging.uploadMojo.platform.client.Executor;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.Request;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Application;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.ApplicationReference;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Applications;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Tenant;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Tenants;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.maven.plugin.logging.Log;

public class PlatformRepository {
    private final Executor executor;
    private final Log log;

    public Optional<Application> findApplicationByName(String name) {
        this.getLog().info((CharSequence)("find application by name " + name));
        Request<Applications> request = Request.Get("application/applicationsByName/:name").withUrlParam(":name", name).withResponse(Applications.class);
        Applications applications = this.getExecutor().execute(request);
        return applications.first();
    }

    public void uploadApplicationBinary(Application application, File content, String name) {
        this.getLog().info((CharSequence)("upload application binary " + application + ", " + content.getAbsolutePath() + ", " + name));
        Request<Map> request = Request.Post("/application/applications/:id/binaries").withUrlParam(":id", application.getId()).withMultipartName(name).withMultipartBody(content);
        this.getExecutor().execute(request);
    }

    public Application createApplication(String name) {
        this.getLog().info((CharSequence)("create application " + name));
        Request<Application> request = Request.Post("application/applications").withJsonBody(new Application().withName(name).withKey(name)).withResponse(Application.class);
        return this.executor.execute(request);
    }

    public void unsubscribeApplication(Tenant tenant, Application application) {
        this.getLog().info((CharSequence)("unsubscribe application " + tenant + ", " + application));
        Request<Map> request = Request.Delete("tenant/tenants/:tenant/applications/:application").withUrlParam(":tenant", tenant.getId()).withUrlParam(":application", application.getId());
        this.executor.execute(request);
    }

    public void subscribeApplication(Tenant tenant, Application application) {
        this.getLog().info((CharSequence)("subscribe application " + tenant + ", " + application));
        Request<ApplicationReference> mapRequest = Request.Post("tenant/tenants/:tenant/applications").withUrlParam(":tenant", tenant.getId()).withJsonBody(new ApplicationReference().withApplication(application)).withResponse(ApplicationReference.class);
        this.executor.execute(mapRequest);
    }

    public Set<Tenant> getSubscriptions(Application application) {
        this.getLog().info((CharSequence)("get subscriptions " + application));
        Request<Tenants> request = Request.Get("tenant/tenants?pageSize=2000").withResponse(Tenants.class);
        Tenants tenants = this.getExecutor().execute(request);
        return tenants.subscribed(application);
    }

    public Set<Tenant> getTenantsByNames(List<String> names) {
        this.getLog().info((CharSequence)("get tenants by names " + names));
        if (names.isEmpty()) {
            return new HashSet<Tenant>();
        }
        Request<Tenants> request = Request.Get("tenant/tenants?pageSize=2000").withResponse(Tenants.class);
        Tenants tenants = this.getExecutor().execute(request);
        return tenants.byNames(names);
    }

    public void deleteApplication(Application application) {
        this.getLog().info((CharSequence)("delete application " + application));
        Request<Map> request = Request.Delete("application/applications/:id").withUrlParam(":id", application.getId());
        try {
            this.executor.execute(request);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage());
        }
    }

    @Generated
    public PlatformRepository(Executor executor, Log log) {
        this.executor = executor;
        this.log = log;
    }

    @Generated
    private Executor getExecutor() {
        return this.executor;
    }

    @Generated
    private Log getLog() {
        return this.log;
    }
}

