/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.microservice;

import java.io.File;
import java.util.Optional;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="microservice-deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class MicroserviceDeployMojo
extends AbstractMojo {
    private static final String SERVER_ID = "microservice";
    @Parameter(defaultValue="${project.build.directory}")
    private File build;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="true", property="skip.microservice.deploy")
    private boolean skip;
    @Parameter(defaultValue="microservice")
    private String serviceId;
    @Parameter(property="package.name", defaultValue="${project.artifactId}")
    private String name;
    @Component
    private WagonManager wagonManager;
    @Component
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping microservice package deployment");
            return;
        }
        Optional<String> serverUrl = this.getServerUrl();
        if (!serverUrl.isPresent()) {
            this.getLog().warn((CharSequence)String.format("URL parameter was not configured, microservice package cannot be deployed. please check your '%s' server configuration in settings.xml", SERVER_ID));
            return;
        }
        String targetFilename = String.format("%s-%s.zip", this.name, this.project.getVersion());
        File file = new File(this.build, targetFilename);
        try {
            Repository repository = new Repository(this.serviceId, serverUrl.get());
            Wagon wagon = this.wagonManager.getWagon(repository);
            wagon.connect(repository, this.wagonManager.getAuthenticationInfo(this.serviceId));
            wagon.put(file, targetFilename);
            wagon.disconnect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getServerUrl() {
        Server server = this.settings.getServer(this.serviceId);
        if (server == null) {
            return Optional.empty();
        }
        Object configuration = server.getConfiguration();
        if (!(configuration instanceof Xpp3Dom)) {
            return Optional.empty();
        }
        Xpp3Dom urlDom = ((Xpp3Dom)configuration).getChild("url");
        return Optional.ofNullable(urlDom).map(Xpp3Dom::getValue);
    }
}

