/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo;

import com.cumulocity.agent.packaging.BaseMicroserviceMojo;
import com.cumulocity.agent.packaging.uploadMojo.configuration.ApplicationConfiguration;
import com.cumulocity.agent.packaging.uploadMojo.configuration.ApplicationConfigurationSupplier;
import com.cumulocity.agent.packaging.uploadMojo.configuration.CredentialsConfiguration;
import com.cumulocity.agent.packaging.uploadMojo.configuration.CredentialsConfigurationSupplier;
import com.cumulocity.agent.packaging.uploadMojo.platform.PlatformRepository;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.impl.ApacheHttpClientExecutor;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Application;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.ApplicationWithSubscriptions;
import com.cumulocity.agent.packaging.uploadMojo.platform.model.Tenant;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="upload", defaultPhase=LifecyclePhase.PACKAGE)
public class MicroserviceUploadMojo
extends BaseMicroserviceMojo {
    @Parameter(defaultValue="microservice")
    private String serviceId;
    @Parameter(property="microservice-upload.skip", defaultValue="true")
    protected boolean skip;
    @Parameter(name="credentials", property="upload.credentials")
    private CredentialsConfiguration credentials;
    @Parameter(name="application", property="upload.application")
    private ApplicationConfiguration application;
    @Parameter(property="upload.application.name")
    private String applicationName;
    @Parameter(property="upload.url")
    private String url;
    @Parameter(property="upload.username")
    private String username;
    @Parameter(property="upload.password")
    private String password;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="package.name", defaultValue="${project.artifactId}", readonly=true)
    private String packageName;
    @Parameter(defaultValue="true", property="skip.microservice.upload")
    protected boolean skipMicroserviceUpload;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private Settings settings;
    private final AtomicReference<Object> applicationSupplier = new AtomicReference();
    private final AtomicReference<Object> credentialsSupplier = new AtomicReference();
    private final AtomicReference<Object> repository = new AtomicReference();

    public void execute() {
        try {
            ApplicationConfiguration configuration;
            if (this.skipMicroserviceUpload) {
                this.getLog().info((CharSequence)"Skipping");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.applicationName)) {
                this.application.setName(this.applicationName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.url)) {
                this.credentials.setUrl(this.url);
            }
            if (StringUtils.isNotBlank((CharSequence)this.username)) {
                this.credentials.setUsername(this.username);
            }
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                this.credentials.setPassword(this.password);
            }
            Optional<CredentialsConfiguration> credentialsMaybe = this.getCredentialsSupplier().getObject();
            Optional<ApplicationConfiguration> applicationMaybe = this.getApplicationSupplier().getObject();
            this.getLog().info((CharSequence)("credentials configuration " + credentialsMaybe));
            this.getLog().info((CharSequence)("application configuration " + applicationMaybe));
            if (!applicationMaybe.isPresent() || !credentialsMaybe.isPresent()) {
                this.getLog().info((CharSequence)("Skipping because present of application: " + applicationMaybe.isPresent() + " or present of credentials: " + credentialsMaybe.isPresent()));
                return;
            }
            File file = this.targetFile();
            if (!file.exists()) {
                this.getLog().info((CharSequence)("Skipping because target file " + file.getAbsolutePath() + " doesn't exist."));
                return;
            }
            PlatformRepository repository = this.getRepository();
            Optional<ApplicationWithSubscriptions> application = this.getOrCreateApplication(repository, configuration = applicationMaybe.get());
            if (application.isPresent()) {
                this.uploadAndSubscribe(repository, application.get(), configuration, file);
            }
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
    }

    private Optional<ApplicationWithSubscriptions> getOrCreateApplication(PlatformRepository repository, ApplicationConfiguration configuration) {
        Optional<Application> applicationMaybe = repository.findApplicationByName(configuration.getName());
        if (configuration.getDelete().booleanValue()) {
            Set<Object> subscriptions = Sets.newHashSet();
            if (applicationMaybe.isPresent()) {
                Application application = applicationMaybe.get();
                subscriptions = repository.getSubscriptions(application);
                for (Tenant tenant : subscriptions) {
                    repository.unsubscribeApplication(tenant, application);
                }
                repository.deleteApplication(application);
            }
            if (configuration.getCreate().booleanValue()) {
                return Optional.of(new ApplicationWithSubscriptions(repository.createApplication(configuration.getName()), subscriptions));
            }
        } else {
            if (applicationMaybe.isPresent()) {
                return Optional.of(new ApplicationWithSubscriptions(applicationMaybe.get()));
            }
            if (configuration.getCreate().booleanValue()) {
                return Optional.of(new ApplicationWithSubscriptions(repository.createApplication(configuration.getName())));
            }
        }
        return Optional.empty();
    }

    private void uploadAndSubscribe(PlatformRepository repository, ApplicationWithSubscriptions application, ApplicationConfiguration configuration, File file) {
        this.uploadFile(repository, application.getApplication(), file);
        application.addSubscriptions(repository.getTenantsByNames(configuration.getSubscriptions()));
        for (Tenant tenant : application.getSubscriptions()) {
            repository.subscribeApplication(tenant, application.getApplication());
        }
    }

    public void uploadFile(PlatformRepository repository, Application application, File file) {
        repository.uploadApplicationBinary(application, file, ApplicationConfiguration.normalizeName(file.getName()));
    }

    private File targetFile() {
        return new File(this.getProject().getBuild().getDirectory(), String.format(this.getTargetFilename("linux/amd64"), this.packageName, this.project.getVersion()));
    }

    @Generated
    public static MicroserviceUploadMojoBuilder builder() {
        return new MicroserviceUploadMojoBuilder();
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    public void setCredentials(CredentialsConfiguration credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setApplication(ApplicationConfiguration application) {
        this.application = application;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setSkipMicroserviceUpload(boolean skipMicroserviceUpload) {
        this.skipMicroserviceUpload = skipMicroserviceUpload;
    }

    @Generated
    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public MicroserviceUploadMojo() {
    }

    @Generated
    public MicroserviceUploadMojo(String serviceId, boolean skip, CredentialsConfiguration credentials, ApplicationConfiguration application, String applicationName, String url, String username, String password, MavenProject project, String packageName, boolean skipMicroserviceUpload, MavenSession mavenSession, Settings settings) {
        this.serviceId = serviceId;
        this.skip = skip;
        this.credentials = credentials;
        this.application = application;
        this.applicationName = applicationName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.project = project;
        this.packageName = packageName;
        this.skipMicroserviceUpload = skipMicroserviceUpload;
        this.mavenSession = mavenSession;
        this.settings = settings;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ApplicationConfigurationSupplier getApplicationSupplier() {
        Object $value = this.applicationSupplier.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.applicationSupplier;
            synchronized (atomicReference) {
                $value = this.applicationSupplier.get();
                if ($value == null) {
                    ApplicationConfigurationSupplier actualValue = new ApplicationConfigurationSupplier(this.serviceId, this.settings, this.application, this.packageName, this.project);
                    $value = actualValue == null ? this.applicationSupplier : actualValue;
                    this.applicationSupplier.set($value);
                }
            }
        }
        return (ApplicationConfigurationSupplier)($value == this.applicationSupplier ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CredentialsConfigurationSupplier getCredentialsSupplier() {
        Object $value = this.credentialsSupplier.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.credentialsSupplier;
            synchronized (atomicReference) {
                $value = this.credentialsSupplier.get();
                if ($value == null) {
                    CredentialsConfigurationSupplier actualValue = new CredentialsConfigurationSupplier(this.serviceId, this.settings, this.credentials);
                    $value = actualValue == null ? this.credentialsSupplier : actualValue;
                    this.credentialsSupplier.set($value);
                }
            }
        }
        return (CredentialsConfigurationSupplier)($value == this.credentialsSupplier ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public PlatformRepository getRepository() {
        Object $value = this.repository.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.repository;
            synchronized (atomicReference) {
                $value = this.repository.get();
                if ($value == null) {
                    PlatformRepository actualValue = new PlatformRepository(new ApacheHttpClientExecutor(this.getCredentialsSupplier().getObject().get(), this.getLog(), this.mavenSession), this.getLog());
                    $value = actualValue == null ? this.repository : actualValue;
                    this.repository.set($value);
                }
            }
        }
        return (PlatformRepository)($value == this.repository ? null : $value);
    }

    @Generated
    public static class MicroserviceUploadMojoBuilder {
        @Generated
        private String serviceId;
        @Generated
        private boolean skip;
        @Generated
        private CredentialsConfiguration credentials;
        @Generated
        private ApplicationConfiguration application;
        @Generated
        private String applicationName;
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private MavenProject project;
        @Generated
        private String packageName;
        @Generated
        private boolean skipMicroserviceUpload;
        @Generated
        private MavenSession mavenSession;
        @Generated
        private Settings settings;

        @Generated
        MicroserviceUploadMojoBuilder() {
        }

        @Generated
        public MicroserviceUploadMojoBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder credentials(CredentialsConfiguration credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder application(ApplicationConfiguration application) {
            this.application = application;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder project(MavenProject project) {
            this.project = project;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder skipMicroserviceUpload(boolean skipMicroserviceUpload) {
            this.skipMicroserviceUpload = skipMicroserviceUpload;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder mavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        @Generated
        public MicroserviceUploadMojoBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public MicroserviceUploadMojo build() {
            return new MicroserviceUploadMojo(this.serviceId, this.skip, this.credentials, this.application, this.applicationName, this.url, this.username, this.password, this.project, this.packageName, this.skipMicroserviceUpload, this.mavenSession, this.settings);
        }

        @Generated
        public String toString() {
            return "MicroserviceUploadMojo.MicroserviceUploadMojoBuilder(serviceId=" + this.serviceId + ", skip=" + this.skip + ", credentials=" + this.credentials + ", application=" + this.application + ", applicationName=" + this.applicationName + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", project=" + this.project + ", packageName=" + this.packageName + ", skipMicroserviceUpload=" + this.skipMicroserviceUpload + ", mavenSession=" + this.mavenSession + ", settings=" + this.settings + ")";
        }
    }
}

