/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.Cpu;
import com.cumulocity.model.DataSize;
import com.cumulocity.model.application.microservice.validation.MinCpu;
import com.cumulocity.model.application.microservice.validation.MinDataSize;
import com.google.common.base.Optional;
import jakarta.validation.constraints.Pattern;
import java.util.Map;
import lombok.Generated;
import org.svenson.JSONProperty;

public class Resources {
    @Pattern(regexp="\\d+(\\.\\d+)?m?", message="Microservice manifest cpu value must either decimal number or millicpu value, for example 0.1 or 100m")
    @MinCpu(value="100m")
    private @Pattern(regexp="\\d+(\\.\\d+)?m?", message="Microservice manifest cpu value must either decimal number or millicpu value, for example 0.1 or 100m") String cpu;
    @Pattern(regexp="^((\\d+)\\s*([BKMGTEP][i]?)?)$", message="Microservice manifest memory invalid, has to be either integer with number of bytes or number with one of the units E, P, T, G, M, K, Ei, Pi, Ti, Gi, Mi, Ki")
    @MinDataSize(value="10M")
    private @Pattern(regexp="^((\\d+)\\s*([BKMGTEP][i]?)?)$", message="Microservice manifest memory invalid, has to be either integer with number of bytes or number with one of the units E, P, T, G, M, K, Ei, Pi, Ti, Gi, Mi, Ki") String memory;

    @JSONProperty(ignore=true)
    public Optional<Cpu> getCpuLimit() {
        return Cpu.tryParse(this.cpu);
    }

    @JSONProperty(ignore=true)
    public Optional<DataSize> getMemoryLimit() {
        return DataSize.tryParse(this.memory);
    }

    public static Resources empty() {
        return Resources.builder().cpu("0m").memory("0M").build();
    }

    public static Resources fromMap(Map<String, Object> map) {
        return Resources.builder().cpu(Resources.getValueFromMap(map, "cpu", "0m")).memory(Resources.getValueFromMap(map, "memory", "0M")).build();
    }

    private static String getValueFromMap(Map<String, Object> map, String key, String defaultValue) {
        Object value = map.get(key);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    @Generated
    public static ResourcesBuilder builder() {
        return new ResourcesBuilder();
    }

    @Generated
    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resources)) {
            return false;
        }
        Resources other = (Resources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cpu = this.getCpu();
        String other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        String this$memory = this.getMemory();
        String other$memory = other.getMemory();
        return !(this$memory == null ? other$memory != null : !this$memory.equals(other$memory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resources;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        String $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Resources(cpu=" + this.getCpu() + ", memory=" + this.getMemory() + ")";
    }

    @Generated
    public Resources() {
    }

    @Generated
    private Resources(String cpu, String memory) {
        this.cpu = cpu;
        this.memory = memory;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public String getCpu() {
        return this.cpu;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public static class ResourcesBuilder {
        @Generated
        private String cpu;
        @Generated
        private String memory;

        @Generated
        ResourcesBuilder() {
        }

        @Generated
        public ResourcesBuilder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public ResourcesBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public Resources build() {
            return new Resources(this.cpu, this.memory);
        }

        @Generated
        public String toString() {
            return "Resources.ResourcesBuilder(cpu=" + this.cpu + ", memory=" + this.memory + ")";
        }
    }
}

