/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.platform.client.impl;

import com.cumulocity.agent.packaging.uploadMojo.platform.client.impl.ProgressInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class ProgressFileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    public ProgressFileBody(File file, ContentType contentType, String filename) {
        super(contentType);
        Args.notNull((Object)file, (String)"File");
        this.file = file;
        this.filename = filename == null ? file.getName() : filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull((Object)out, (String)"Output stream");
        try (InputStream in = this.createInputStream(this.file);){
            int l;
            byte[] tmp = new byte[32768];
            while ((l = in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
    }

    protected InputStream createInputStream(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return ProgressInputStream.builder().inputStream(fileInputStream).maxNumBytes(file.length()).progressListener(new ProgressInputStream.SysOutProgress()).build();
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public long getContentLength() {
        return this.file.length();
    }

    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

