/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.monitoring.health.indicator.memory;

import com.cumulocity.microservice.monitoring.health.indicator.memory.AbstractMemoryHealthIndicatorProperties;
import com.cumulocity.microservice.monitoring.health.indicator.memory.HeapMemoryHealthIndicator;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public abstract class AbstractMemoryHealthIndicator
extends AbstractHealthIndicator {
    private static final long UNDEFINED = -1L;
    private static final Log logger = LogFactory.getLog(HeapMemoryHealthIndicator.class);
    private final AbstractMemoryHealthIndicatorProperties properties;

    protected AbstractMemoryHealthIndicator(AbstractMemoryHealthIndicatorProperties properties) {
        this.properties = properties;
    }

    protected final void doHealthCheck(Health.Builder builder) throws Exception {
        MemoryUsage memoryUsage = this.getMemoryUsage(this.properties.getMemoryMXBean());
        long available = memoryUsage.getMax() - memoryUsage.getUsed();
        long threshold = AbstractMemoryHealthIndicator.getThreshold(memoryUsage, this.properties.getThreshold());
        if (-1L == threshold || available > threshold) {
            builder.up();
        } else {
            logger.warn((Object)String.format("Free memory below threshold. Available: %d bytes (threshold: %d bytes)", available, threshold));
            builder.down();
        }
        builder.withDetail("init", (Object)memoryUsage.getInit()).withDetail("used", (Object)memoryUsage.getUsed()).withDetail("committed", (Object)memoryUsage.getCommitted()).withDetail("max", (Object)memoryUsage.getMax()).withDetail("threshold", (Object)threshold);
    }

    protected abstract MemoryUsage getMemoryUsage(MemoryMXBean var1);

    private static long getThreshold(MemoryUsage memoryUsage, double threshold) {
        return -1L == memoryUsage.getMax() ? -1L : (long)((double)memoryUsage.getMax() * threshold);
    }
}

