/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.monitoring.health.indicator.platform;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.monitoring.health.indicator.platform.PlatformHealthIndicatorProperties;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityCredentialsFactory;
import com.cumulocity.sdk.client.ClientConfiguration;
import com.cumulocity.sdk.client.PlatformParameters;
import com.cumulocity.sdk.client.ResponseMapper;
import com.cumulocity.sdk.client.ResponseParser;
import com.cumulocity.sdk.client.RestConnector;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component
public class PlatformHealthIndicator
extends AbstractHealthIndicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlatformHealthIndicator.class);
    private final ContextService<MicroserviceCredentials> microservice;
    private final PlatformProperties properties;
    private final PlatformHealthIndicatorProperties configuration;

    protected void doHealthCheck(Health.Builder builder) {
        try {
            Map details;
            RestConnector rest = new RestConnector(this.platformParameters(), new ResponseParser((ResponseMapper)new JacksonResponseMapper()));
            Response response = rest.get(this.configuration.getPath(), MediaType.APPLICATION_JSON_TYPE);
            if (response.getStatus() == 200) {
                builder.up();
            } else {
                builder.unknown().withDetail("message", (Object)String.format("Platform respond with wrong status %s", response.getStatus()));
            }
            if (this.configuration.getDetails().getEnabled().booleanValue() && response.getStatus() == 200 && (details = (Map)rest.get(this.configuration.getDetails().getPath(), MediaType.APPLICATION_JSON_TYPE, Map.class)).containsKey("status")) {
                this.assignDetails(builder, details);
            }
            log.debug("health {}", (Object)builder.build());
        }
        catch (Exception ex) {
            log.warn("Error while checking connection to the platform", (Throwable)ex);
            builder.down((Throwable)ex).withDetail("message", (Object)ex.getMessage());
        }
    }

    private void assignDetails(Health.Builder builder, Map<String, Object> health) {
        for (Map.Entry<String, Object> entry : health.entrySet()) {
            if (entry.getKey().equals("status")) continue;
            builder.withDetail(entry.getKey(), entry.getValue());
        }
    }

    private PlatformParameters platformParameters() {
        Credentials context = this.getCredentials();
        CumulocityCredentials credentials = new CumulocityCredentialsFactory().withUsername(context.getUsername()).withTenant(context.getTenant()).withPassword(context.getPassword()).withOAuthAccessToken(context.getOAuthAccessToken()).withXsrfToken(context.getXsrfToken()).withApplicationKey(context.getAppKey()).getCredentials();
        PlatformParameters params = new PlatformParameters((String)this.properties.getUrl().get(), credentials, new ClientConfiguration());
        params.setForceInitialHost(this.properties.getForceInitialHost());
        params.setTfaToken(context.getTfaToken());
        return params;
    }

    private Credentials getCredentials() {
        if (this.microservice.isInContext()) {
            return (Credentials)this.microservice.getContext();
        }
        return this.properties.getMicroserviceBoostrapUser();
    }

    @Generated
    public PlatformHealthIndicator(ContextService<MicroserviceCredentials> microservice, PlatformProperties properties, PlatformHealthIndicatorProperties configuration) {
        this.microservice = microservice;
        this.properties = properties;
        this.configuration = configuration;
    }

    private static final class JacksonResponseMapper
    implements ResponseMapper {
        private final ObjectMapper mapper = new ObjectMapper();

        public <T> T read(InputStream stream, Class<T> clazz) {
            return (T)this.mapper.readValue(stream, clazz);
        }

        public String write(Object object) {
            return this.mapper.writeValueAsString(object);
        }
    }
}

