/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.logging.configuration;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.cumulocity.microservice.properties.ConfigurationFileProvider;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Order(value=5)
public class LoggingEnvironmentRunListener
implements SpringApplicationRunListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingEnvironmentRunListener.class);

    public LoggingEnvironmentRunListener(SpringApplication application, String[] args) {
    }

    public void starting(ConfigurableBootstrapContext bootstrapContext) {
    }

    public void environmentPrepared(ConfigurableEnvironment configurableEnvironment) {
        this.initLogging(new ConfigurationFileProvider((Environment)configurableEnvironment));
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        this.environmentPrepared(environment);
    }

    public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
    }

    public void ready(ConfigurableApplicationContext context, Duration timeTaken) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    public void initLogging(ConfigurationFileProvider configurationFileProvider) {
        Iterable paths = Iterables.concat((Iterable)configurationFileProvider.find(new String[]{"-logging.xml", "-server-logging.xml", "-agent-server-logging.xml"}), (Iterable)configurationFileProvider.find(new String[]{"logging"}, new String[]{".xml"}));
        for (Path path : paths) {
            if (path == null || !Files.exists(path, new LinkOption[0])) continue;
            LoggingEnvironmentRunListener.setupLoggingFile(path.toFile());
            return;
        }
    }

    private static File setupLoggingFile(File file) {
        log.info("logging.conf: {}", (Object)file.getAbsoluteFile());
        if (!file.getAbsoluteFile().getName().equals(System.getProperty("logging.conf"))) {
            System.setProperty("logging.conf", file.getAbsolutePath());
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)context);
                context.reset();
                configurator.doConfigure(file);
            }
            catch (JoranException joranException) {
                // empty catch block
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        return file;
    }
}

