/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ContextServiceImpl<C>
implements ContextService<C> {
    private static final Logger log = LoggerFactory.getLogger(ContextServiceImpl.class);
    private static final String TENANT_LOG_FLAG = "tenant";
    private static final String DEVICE_LOG_FLAG = "device";
    private static ThreadLocal<LinkedList<Object>> localContext = new ThreadLocal<LinkedList<Object>>(){

        @Override
        protected LinkedList<Object> initialValue() {
            return new LinkedList<Object>();
        }
    };
    private final Class<C> clazz;

    public ContextServiceImpl(Class<C> c) {
        this.clazz = c;
    }

    @Override
    public C getContext() {
        C context = this.doGetContext();
        if (context == null) {
            throw new IllegalStateException("Not within any context!");
        }
        return context;
    }

    @Override
    public boolean isInContext() {
        return this.doGetContext() != null;
    }

    private C doGetContext() {
        return (C)FluentIterable.from((Iterable)Lists.reverse((List)localContext.get())).firstMatch((Predicate)new Predicate<Object>(){

            public boolean apply(Object o) {
                return ContextServiceImpl.this.clazz.isInstance(o);
            }
        }).transform(new Function<Object, C>(){

            public C apply(Object o) {
                return o;
            }
        }).orNull();
    }

    @Override
    public void runWithinContext(C context, Runnable task) {
        try {
            this.callWithinContext(context, new CallableRunnableWrapper(task));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> V callWithinContext(C context, Callable<V> task) {
        this.enterContext(context);
        try {
            V v = task.call();
            return v;
        }
        catch (Exception e) {
            log.warn("execution of task failed within tenant : {} - {} ", (Object)ContextServiceImpl.getContextTenant(context), (Object)e.getMessage());
            log.debug("execution of task failed within tenant : {} ", (Object)ContextServiceImpl.getContextTenant(context), (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.leaveContext();
        }
    }

    private void enterContext(C newContext) {
        MDC.put((String)TENANT_LOG_FLAG, (String)ContextServiceImpl.getContextTenant(newContext));
        MDC.put((String)DEVICE_LOG_FLAG, (String)ContextServiceImpl.getContextDevice(newContext));
        log.debug("entering to  {} ", newContext);
        localContext.get().add(newContext);
    }

    private void leaveContext() {
        MDC.remove((String)TENANT_LOG_FLAG);
        MDC.remove((String)DEVICE_LOG_FLAG);
        localContext.get().removeLast();
        C previousContext = this.doGetContext();
        if (previousContext != null) {
            MDC.put((String)TENANT_LOG_FLAG, (String)ContextServiceImpl.getContextTenant(previousContext));
            MDC.put((String)DEVICE_LOG_FLAG, (String)ContextServiceImpl.getContextDevice(previousContext));
        }
    }

    @Override
    public Runnable withinContext(final C context, final Runnable task) {
        return new Runnable(){

            @Override
            public void run() {
                ContextServiceImpl.this.runWithinContext(context, task);
            }
        };
    }

    @Override
    public <V> Callable<V> withinContext(final C context, final Callable<V> task) {
        return new Callable<V>(){

            @Override
            public V call() {
                return ContextServiceImpl.this.callWithinContext(context, task);
            }
        };
    }

    private static String getContextDevice(Object credentials) {
        if (credentials instanceof UserCredentials) {
            return ((UserCredentials)credentials).getIdentifier();
        }
        return null;
    }

    private static String getContextTenant(Object credentials) {
        if (credentials instanceof Credentials) {
            return ((Credentials)credentials).getTenant();
        }
        return null;
    }

    private static class CallableRunnableWrapper
    implements Callable<Void> {
        private final Runnable runnable;

        public CallableRunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Void call() {
            this.runnable.run();
            return null;
        }
    }
}

