/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context.scope;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class KeyBasedLocksMap {
    private final ConcurrentMap<Object, ReentrantLock> locks = new ConcurrentHashMap<Object, ReentrantLock>();

    public static Object createLockKey(Object ... keyElements) {
        return new LockKey(keyElements);
    }

    public KeyBasedLock lockForKeyElements(Object ... keyElements) {
        return this.lockForKey(KeyBasedLocksMap.createLockKey(keyElements));
    }

    public KeyBasedLock lockForKey(Object lockKey) {
        ReentrantLock myLock = (ReentrantLock)this.locks.get(lockKey);
        if (myLock != null && myLock.isHeldByCurrentThread()) {
            myLock.lock();
            return new KeyBasedLock(lockKey, myLock);
        }
        myLock = new ReentrantLock();
        myLock.lock();
        ReentrantLock otherLock = null;
        do {
            if ((otherLock = this.locks.putIfAbsent(lockKey, myLock)) == null) continue;
            otherLock.lock();
            myLock.unlock();
            myLock = otherLock;
        } while (otherLock != null);
        return new KeyBasedLock(lockKey, myLock);
    }

    void unlockKey(Object lockKey, ReentrantLock myLock) {
        if (myLock.getHoldCount() == 1) {
            this.locks.remove(lockKey);
        }
        myLock.unlock();
    }

    private static class LockKey {
        private Object[] keyElements;

        public LockKey(Object ... keyElements) {
            this.keyElements = keyElements;
        }

        public int hashCode() {
            int hash = 0;
            if (this.keyElements != null) {
                for (Object element : this.keyElements) {
                    hash += element == null ? 0 : element.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LockKey)) {
                return false;
            }
            LockKey other = (LockKey)obj;
            if (this.keyElements == null) {
                return other.keyElements == null;
            }
            if (other.keyElements == null) {
                return false;
            }
            if (this.keyElements.length != other.keyElements.length) {
                return false;
            }
            for (int i = 0; i < this.keyElements.length; ++i) {
                if (!(this.keyElements[i] == null || other.keyElements[i] == null ? this.keyElements != other.keyElements : !this.keyElements[i].equals(other.keyElements[i]))) continue;
                return false;
            }
            return true;
        }
    }

    public class KeyBasedLock {
        private Object lockKey;
        private ReentrantLock lock;

        KeyBasedLock(Object lockKey, ReentrantLock lock) {
            this.lockKey = lockKey;
            this.lock = lock;
        }

        public void unlock() {
            KeyBasedLocksMap.this.unlockKey(this.lockKey, this.lock);
        }
    }
}

