/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context.scope;

import com.cumulocity.microservice.context.scope.ScopeContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScopeContainer
implements ScopeContainer {
    private final Logger log = LoggerFactory.getLogger(DefaultScopeContainer.class);
    private final ConcurrentMap<String, Object> objectsMap = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, List<Runnable>> callbacksMap = new ConcurrentHashMap<String, List<Runnable>>();
    private final ConcurrentMap<String, Object> objectsInDestruction = new ConcurrentHashMap<String, Object>();
    private volatile boolean containerInDestruction = false;

    @Override
    public Set<String> getObjectNames() {
        this.ensureContainerNotInDestruction();
        return this.objectsMap.keySet();
    }

    @Override
    public boolean contains(String name) {
        this.ensureObjectNotInDestruction(name);
        return this.objectsMap.containsKey(name);
    }

    @Override
    public Object getObject(String name) {
        this.ensureObjectNotInDestruction(name);
        return this.objectsMap.get(name);
    }

    @Override
    public void putObject(String name, Object obj) {
        this.ensureObjectNotInDestruction(name);
        Object previous = this.objectsMap.putIfAbsent(name, obj);
        if (previous != null) {
            IllegalArgumentException exception = new IllegalArgumentException(String.format("Object with name %s is already present in the container!", name));
            this.log.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public Object removeObject(String name) {
        this.ensureContainerNotInDestruction();
        return this.doRemoveObject(name);
    }

    @Override
    public void addDestructionCallback(String name, Runnable callback) {
        this.ensureObjectNotInDestruction(name);
        ArrayList<Runnable> list = (ArrayList<Runnable>)this.callbacksMap.get(name);
        if (list == null) {
            list = new ArrayList<Runnable>();
            this.callbacksMap.put(name, list);
        }
        list.add(callback);
    }

    @Override
    public void clear() {
        this.ensureContainerNotInDestruction();
        this.containerInDestruction = true;
        try {
            for (String name : this.objectsMap.keySet()) {
                this.doRemoveObject(name);
            }
            this.objectsMap.clear();
            this.callbacksMap.clear();
        }
        finally {
            this.containerInDestruction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doRemoveObject(String name) {
        if (this.objectsInDestruction.putIfAbsent(name, name) != null) {
            throw new IllegalStateException("The object is currently in destruction!");
        }
        try {
            Object removed = this.objectsMap.remove(name);
            this.runDestructionCallbacks(name);
            Object v = removed;
            return v;
        }
        finally {
            this.objectsInDestruction.remove(name);
        }
    }

    private void runDestructionCallbacks(String name) {
        List list = (List)this.callbacksMap.remove(name);
        if (list == null) {
            return;
        }
        for (Runnable callback : list) {
            callback.run();
        }
    }

    private void ensureContainerNotInDestruction() {
        if (this.containerInDestruction) {
            throw new IllegalStateException("The scope container is currently in destruction!");
        }
    }

    private void ensureObjectNotInDestruction(String name) {
        this.ensureContainerNotInDestruction();
        if (this.objectsInDestruction.containsKey(name)) {
            throw new IllegalStateException("The object is currently in destruction!");
        }
    }
}

