/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context.credentials;

import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityCredentialsFactory;
import java.beans.ConstructorProperties;

public class MicroserviceCredentials
implements Credentials {
    private String tenant;
    private String username;
    private String password;
    private String oAuthAccessToken;
    private String xsrfToken;
    private String tfaToken;
    private String appKey;

    @ConstructorProperties(value={"tenant", "username", "password", "oAuthAccessToken", "xsrfToken", "tfaToken", "appKey"})
    public MicroserviceCredentials(String tenant, String username, String password, String oAuthAccessToken, String xsrfToken, String tfaToken, String appKey) {
        this.tenant = tenant;
        this.username = username;
        this.password = password;
        this.oAuthAccessToken = oAuthAccessToken;
        this.xsrfToken = xsrfToken;
        this.tfaToken = tfaToken;
        this.appKey = appKey;
    }

    public MicroserviceCredentials() {
    }

    public static MicroserviceCredentialsBuilder builder() {
        return new MicroserviceCredentialsBuilder();
    }

    public static MicroserviceCredentialsBuilder copyOf(MicroserviceCredentials source) {
        return MicroserviceCredentials.builder().tenant(source.getTenant()).username(source.getUsername()).password(source.getPassword()).oAuthAccessToken(source.getOAuthAccessToken()).xsrfToken(source.getXsrfToken()).tfaToken(source.getTfaToken()).appKey(source.getAppKey());
    }

    public UserCredentials withIdentifier(String identifier) {
        return UserCredentials.builder().tenant(this.tenant).username(this.username).password(this.password).oAuthAccessToken(this.oAuthAccessToken).xsrfToken(this.xsrfToken).identifier(identifier).tfaToken(this.tfaToken).appKey(this.appKey).build();
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    @Override
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @Override
    public String getTfaToken() {
        return this.tfaToken;
    }

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    public CumulocityCredentials toCumulocityCredentials() {
        return new CumulocityCredentialsFactory().withUsername(this.getUsername()).withTenant(this.getTenant()).withPassword(this.getPassword()).withOAuthAccessToken(this.getOAuthAccessToken()).withXsrfToken(this.getXsrfToken()).withApplicationKey(this.getAppKey()).getCredentials();
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTfaToken(String tfaToken) {
        this.tfaToken = tfaToken;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroserviceCredentials)) {
            return false;
        }
        MicroserviceCredentials other = (MicroserviceCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$oAuthAccessToken = this.getOAuthAccessToken();
        String other$oAuthAccessToken = other.getOAuthAccessToken();
        if (this$oAuthAccessToken == null ? other$oAuthAccessToken != null : !this$oAuthAccessToken.equals(other$oAuthAccessToken)) {
            return false;
        }
        String this$xsrfToken = this.getXsrfToken();
        String other$xsrfToken = other.getXsrfToken();
        if (this$xsrfToken == null ? other$xsrfToken != null : !this$xsrfToken.equals(other$xsrfToken)) {
            return false;
        }
        String this$tfaToken = this.getTfaToken();
        String other$tfaToken = other.getTfaToken();
        if (this$tfaToken == null ? other$tfaToken != null : !this$tfaToken.equals(other$tfaToken)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        return !(this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $oAuthAccessToken = this.getOAuthAccessToken();
        result = result * 59 + ($oAuthAccessToken == null ? 43 : $oAuthAccessToken.hashCode());
        String $xsrfToken = this.getXsrfToken();
        result = result * 59 + ($xsrfToken == null ? 43 : $xsrfToken.hashCode());
        String $tfaToken = this.getTfaToken();
        result = result * 59 + ($tfaToken == null ? 43 : $tfaToken.hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MicroserviceCredentials;
    }

    public MicroserviceCredentials withTenant(String tenant) {
        return this.tenant == tenant ? this : new MicroserviceCredentials(tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.tfaToken, this.appKey);
    }

    public MicroserviceCredentials withUsername(String username) {
        return this.username == username ? this : new MicroserviceCredentials(this.tenant, username, this.password, this.oAuthAccessToken, this.xsrfToken, this.tfaToken, this.appKey);
    }

    public MicroserviceCredentials withPassword(String password) {
        return this.password == password ? this : new MicroserviceCredentials(this.tenant, this.username, password, this.oAuthAccessToken, this.xsrfToken, this.tfaToken, this.appKey);
    }

    public MicroserviceCredentials withOAuthAccessToken(String oAuthAccessToken) {
        return this.oAuthAccessToken == oAuthAccessToken ? this : new MicroserviceCredentials(this.tenant, this.username, this.password, oAuthAccessToken, this.xsrfToken, this.tfaToken, this.appKey);
    }

    public MicroserviceCredentials withXsrfToken(String xsrfToken) {
        return this.xsrfToken == xsrfToken ? this : new MicroserviceCredentials(this.tenant, this.username, this.password, this.oAuthAccessToken, xsrfToken, this.tfaToken, this.appKey);
    }

    public MicroserviceCredentials withTfaToken(String tfaToken) {
        return this.tfaToken == tfaToken ? this : new MicroserviceCredentials(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, tfaToken, this.appKey);
    }

    public MicroserviceCredentials withAppKey(String appKey) {
        return this.appKey == appKey ? this : new MicroserviceCredentials(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.tfaToken, appKey);
    }

    public String toString() {
        return "MicroserviceCredentials(tenant=" + this.getTenant() + ", username=" + this.getUsername() + ")";
    }

    public static class MicroserviceCredentialsBuilder {
        private String tenant;
        private String username;
        private String password;
        private String oAuthAccessToken;
        private String xsrfToken;
        private String tfaToken;
        private String appKey;

        MicroserviceCredentialsBuilder() {
        }

        public MicroserviceCredentialsBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public MicroserviceCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MicroserviceCredentialsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MicroserviceCredentialsBuilder oAuthAccessToken(String oAuthAccessToken) {
            this.oAuthAccessToken = oAuthAccessToken;
            return this;
        }

        public MicroserviceCredentialsBuilder xsrfToken(String xsrfToken) {
            this.xsrfToken = xsrfToken;
            return this;
        }

        public MicroserviceCredentialsBuilder tfaToken(String tfaToken) {
            this.tfaToken = tfaToken;
            return this;
        }

        public MicroserviceCredentialsBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public MicroserviceCredentials build() {
            return new MicroserviceCredentials(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.tfaToken, this.appKey);
        }

        public String toString() {
            return "MicroserviceCredentials.MicroserviceCredentialsBuilder(tenant=" + this.tenant + ", username=" + this.username + ", password=" + this.password + ", oAuthAccessToken=" + this.oAuthAccessToken + ", xsrfToken=" + this.xsrfToken + ", tfaToken=" + this.tfaToken + ", appKey=" + this.appKey + ")";
        }
    }
}

