/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context.annotation;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.ContextServiceImpl;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.context.scope.BaseScope;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
public class EnableContextSupportConfiguration {
    public static final String USER_SCOPE = "user";
    public static final String TENANT_SCOPE = "tenant";

    @Bean
    public ContextService<Credentials> credentialsContextService() {
        return new ContextServiceImpl<Credentials>(Credentials.class);
    }

    @Bean
    public ContextService<MicroserviceCredentials> microserviceContextService() {
        return new ContextServiceImpl<MicroserviceCredentials>(MicroserviceCredentials.class);
    }

    @Bean
    public ContextService<UserCredentials> userContextService() {
        return new ContextServiceImpl<UserCredentials>(UserCredentials.class);
    }

    @Bean
    public PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public CustomScopeConfigurer contextScopeConfigurer(final ContextService<MicroserviceCredentials> microserviceContextService, final ContextService<UserCredentials> userContextService, @Value(value="${tenantCacheExpirationTimeout:300000}") Long cacheExpirationTimeout) {
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.setScopes((Map)ImmutableMap.builder().put((Object)USER_SCOPE, (Object)new BaseScope(true){

            @Override
            protected String getContextId() {
                UserCredentials context = (UserCredentials)userContextService.getContext();
                return context.getTenant() + "/" + context.getUsername() + ":" + context.getPassword() + "," + context.getAppKey() + "," + context.getOAuthAccessToken() + ":" + context.getXsrfToken() + "," + context.getTfaToken();
            }
        }).put((Object)TENANT_SCOPE, (Object)new BaseScope(true, cacheExpirationTimeout){

            @Override
            protected String getContextId() {
                MicroserviceCredentials context = (MicroserviceCredentials)microserviceContextService.getContext();
                return context.getTenant() + "/" + context.getUsername() + ":" + context.getPassword() + "," + context.getAppKey() + "," + context.getOAuthAccessToken() + ":" + context.getXsrfToken() + "," + context.getTfaToken();
            }
        }).build());
        return configurer;
    }
}

