/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.context.scope;

import com.cumulocity.microservice.context.scope.DefaultScopeContainer;
import com.cumulocity.microservice.context.scope.KeyBasedLocksMap;
import com.cumulocity.microservice.context.scope.ScopeContainer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public abstract class BaseScope
implements Scope {
    public static final int DEFAULT_CACHE_EXPIRATION_TIMEOUT = 300000;
    private static final Logger log = LoggerFactory.getLogger(BaseScope.class);
    private final KeyBasedLocksMap locks = new KeyBasedLocksMap();
    private LoadingCache<String, ScopeContainer> scopes;
    private final boolean sync;
    private final long cacheExpirationTimeout;

    public BaseScope(boolean sync) {
        this(sync, 300000L);
    }

    public BaseScope(boolean sync, long cacheExpirationTimeout) {
        this.sync = sync;
        this.cacheExpirationTimeout = cacheExpirationTimeout <= 0L ? Long.MAX_VALUE : cacheExpirationTimeout;
        this.initializeCache();
    }

    private void initializeCache() {
        this.scopes = CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterAccess(this.cacheExpirationTimeout, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, ScopeContainer>(){

            public void onRemoval(RemovalNotification<String, ScopeContainer> removalNotification) {
                ((ScopeContainer)removalNotification.getValue()).clear();
                log.debug("bean was removed, key: {}", removalNotification.getKey());
            }
        }).build((CacheLoader)new CacheLoader<String, ScopeContainer>(){

            public ScopeContainer load(String key) {
                return new DefaultScopeContainer();
            }
        });
    }

    protected abstract String getContextId();

    protected ScopeContainer getScopeContainer() {
        return (ScopeContainer)this.scopes.getUnchecked((Object)this.getContextId());
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        if (this.sync) {
            return this.doGetSynchronized(name, objectFactory);
        }
        return this.doGet(name, objectFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGetSynchronized(String name, ObjectFactory<?> objectFactory) {
        KeyBasedLocksMap.KeyBasedLock lock = this.locks.lockForKeyElements(this.getContextId(), name);
        try {
            Object object = this.doGet(name, objectFactory);
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    protected Object doGet(String name, ObjectFactory<?> objectFactory) {
        ScopeContainer scopeContainer = this.getScopeContainer();
        if (scopeContainer.contains(name)) {
            return this.getExisting(scopeContainer, name);
        }
        return this.createNew(scopeContainer, name, objectFactory);
    }

    private Object getExisting(ScopeContainer container, String name) {
        Object scoped = container.getObject(name);
        log.trace("Returned existing scoped instance of bean '{}' for '{}'.", (Object)name, (Object)this.getContextId());
        return scoped;
    }

    private Object createNew(ScopeContainer container, String name, ObjectFactory<?> objectFactory) {
        Object scoped = this.getObjectFromFactory(objectFactory);
        container.putObject(name, scoped);
        log.trace("Created new scoped instance of bean '{}' for '{}'.", (Object)name, (Object)this.getContextId());
        return scoped;
    }

    public Object remove(String name) {
        log.trace("Removing tenant scoped instance of bean '{}' for tenant '{}'.", (Object)name, (Object)this.getContextId());
        return this.getScopeContainer().removeObject(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        log.trace("Registering destruction callback for tenant scoped bean '{}' for tenant '{}'.", (Object)name, (Object)this.getContextId());
        this.getScopeContainer().addDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return this.getContextId();
    }

    public long getCacheExpirationTimeout() {
        return this.cacheExpirationTimeout;
    }

    protected Object getObjectFromFactory(ObjectFactory<?> objectFactory) {
        return objectFactory.getObject();
    }
}

