/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.rest;

import com.cumulocity.microservice.customdecoders.api.exception.DecoderServiceException;
import com.cumulocity.microservice.customdecoders.api.exception.InvalidInputDataException;
import com.cumulocity.microservice.customdecoders.api.model.DecoderInputData;
import com.cumulocity.microservice.customdecoders.api.model.DecoderResult;
import com.cumulocity.microservice.customdecoders.api.service.DecoderService;
import com.cumulocity.microservice.customencoders.api.exception.EncoderServiceException;
import com.cumulocity.microservice.customencoders.api.exception.InvalidCommandDataException;
import com.cumulocity.microservice.customencoders.api.model.EncoderInputData;
import com.cumulocity.microservice.customencoders.api.model.EncoderResult;
import com.cumulocity.microservice.customencoders.api.service.EncoderService;
import com.cumulocity.model.idtype.GId;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CodecController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodecController.class);
    @Autowired(required=false)
    private DecoderService decoderService;
    @Autowired(required=false)
    private EncoderService encoderService;

    @PostMapping(value={"/decode"}, consumes={"application/json"})
    @NotNull
    public DecoderResult decode(@RequestBody @NotNull DecoderInputData inputData) throws DecoderServiceException {
        if (this.decoderService == null) {
            UnsupportedOperationException exception = new UnsupportedOperationException("No implementation provided for the DecoderService");
            throw new DecoderServiceException((Throwable)exception, exception.getMessage(), DecoderResult.empty());
        }
        try {
            if (Objects.isNull(inputData)) {
                throw new IllegalArgumentException("Decoder is invoked with null input data.");
            }
            log.debug("Decoder is invoked with the following input data \\n {}", (Object)inputData);
            return this.decoderService.decode(inputData.getValue(), GId.asGId((String)inputData.getSourceDeviceId()), inputData.getArgs());
        }
        catch (IllegalArgumentException e) {
            log.error("Decoder failed as it received invalid input.", (Throwable)e);
            throw new InvalidInputDataException((Throwable)e, e.getMessage(), DecoderResult.empty());
        }
    }

    @PostMapping(value={"/encode"}, consumes={"application/json"})
    @NotNull
    public EncoderResult encode(@RequestBody @NotNull EncoderInputData inputData) throws EncoderServiceException {
        if (this.encoderService == null) {
            UnsupportedOperationException exception = new UnsupportedOperationException("No implementation provided for the EncoderService");
            throw new EncoderServiceException((Throwable)exception, exception.getMessage(), EncoderResult.empty());
        }
        try {
            if (Objects.isNull(inputData)) {
                throw new IllegalArgumentException("Encoder is invoked with null input data.");
            }
            log.debug("Encoder is invoked with the following input data \\n {}", (Object)inputData);
            return this.encoderService.encode(inputData);
        }
        catch (IllegalArgumentException e) {
            log.error("Encoder failed as it received invalid input.", (Throwable)e);
            throw new InvalidCommandDataException((Throwable)e, e.getMessage(), EncoderResult.empty());
        }
    }
}

