/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.model;

import com.cumulocity.microservice.lpwan.codec.model.DeviceCommand;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class DeviceInfo {
    public static final String DEVICE_MANUFACTURER = "deviceManufacturer";
    public static final String DEVICE_MODEL = "deviceModel";
    static final String SUPPORTED_DEVICE_COMMANDS = "supportedDeviceCommands";
    @NotBlank
    private String deviceManufacturer;
    @NotBlank
    private String deviceModel;
    @Null
    @JsonProperty(value="supportedDeviceCommands")
    private Set<DeviceCommand> supportedCommands;

    public DeviceInfo(@NotBlank String deviceManufacturer, @NotBlank String deviceModel) {
        this(deviceManufacturer, deviceModel, null);
    }

    public DeviceInfo(@NotBlank String deviceManufacturer, @NotBlank String deviceModel, @Null Set<DeviceCommand> supportedCommands) {
        this.deviceManufacturer = deviceManufacturer;
        this.deviceModel = deviceModel;
        this.supportedCommands = supportedCommands;
    }

    public DeviceInfo(@NotNull Map<String, String> properties) {
        this(properties.get(DEVICE_MANUFACTURER), properties.get(DEVICE_MODEL));
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(3);
        attributes.put(DEVICE_MANUFACTURER, this.deviceManufacturer);
        attributes.put(DEVICE_MODEL, this.deviceModel);
        if (Objects.nonNull(this.supportedCommands)) {
            ArrayList<Map<String, Object>> supportedCommandsAttributesList = new ArrayList<Map<String, Object>>();
            attributes.put(SUPPORTED_DEVICE_COMMANDS, supportedCommandsAttributesList);
            for (DeviceCommand supportedCommand : this.supportedCommands) {
                supportedCommandsAttributesList.add(supportedCommand.getAttributes());
            }
        }
        return attributes;
    }

    public void validate() {
        ArrayList<String> missingParameters = new ArrayList<String>(3);
        if (Strings.isNullOrEmpty((String)this.deviceManufacturer)) {
            missingParameters.add("'manufacturer'");
        }
        if (Strings.isNullOrEmpty((String)this.deviceModel)) {
            missingParameters.add("'model'");
        }
        if (Objects.nonNull(this.supportedCommands) && !this.supportedCommands.isEmpty()) {
            for (DeviceCommand supportedCommand : this.supportedCommands) {
                try {
                    supportedCommand.validate();
                }
                catch (IllegalArgumentException e) {
                    missingParameters.add("'name, category and/or command'");
                }
            }
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("DeviceInfo is missing mandatory parameters: " + String.join((CharSequence)", ", missingParameters));
        }
    }

    @Generated
    public DeviceInfo() {
    }

    @Generated
    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    @Generated
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Generated
    public Set<DeviceCommand> getSupportedCommands() {
        return this.supportedCommands;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$deviceManufacturer = this.getDeviceManufacturer();
        String other$deviceManufacturer = other.getDeviceManufacturer();
        if (this$deviceManufacturer == null ? other$deviceManufacturer != null : !this$deviceManufacturer.equals(other$deviceManufacturer)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        return !(this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceManufacturer = this.getDeviceManufacturer();
        result = result * 59 + ($deviceManufacturer == null ? 43 : $deviceManufacturer.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        return result;
    }
}

