/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.encoder.model;

import com.cumulocity.microservice.customencoders.api.model.EncoderResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class LpwanEncoderResult
extends EncoderResult {
    public static final String FPORT_KEY = "fport";

    public LpwanEncoderResult(@NotBlank String encodedCommand, @Null Integer fport) {
        this.setEncodedCommand(encodedCommand);
        this.setFport(fport);
        this.validate();
    }

    @JsonIgnore
    @Null
    public Integer getFport() {
        String fportstring = this.getPropertiesMap().get(FPORT_KEY);
        if (!Strings.isNullOrEmpty((String)fportstring)) {
            return Integer.valueOf(fportstring);
        }
        return null;
    }

    private void setFport(@Null Integer fport) {
        if (Objects.nonNull(fport)) {
            this.getPropertiesMap().put(FPORT_KEY, fport.toString());
        }
    }

    @NotNull
    private Map<String, String> getPropertiesMap() {
        HashMap properties = super.getProperties();
        if (Objects.isNull(properties)) {
            properties = new HashMap();
            super.setProperties(properties);
        }
        return properties;
    }

    private void validate() {
        ArrayList<String> missingParameters = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)this.getEncodedCommand())) {
            missingParameters.add("'encodedCommand'");
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("LpwanEncoderResult is missing mandatory fields: " + String.join((CharSequence)", ", missingParameters));
        }
    }

    @Generated
    public LpwanEncoderResult() {
    }
}

