/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.lpwan.codec.Codec;
import com.cumulocity.microservice.lpwan.codec.PredefinedCommandFilter;
import com.cumulocity.microservice.lpwan.codec.model.DeviceCommand;
import com.cumulocity.microservice.lpwan.codec.model.DeviceInfo;
import com.cumulocity.microservice.lpwan.codec.model.LpwanCodecDetails;
import com.cumulocity.microservice.subscription.model.MicroserviceSubscriptionAddedEvent;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApi;
import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjects;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.cumulocity.sdk.client.inventory.InventoryFilter;
import com.cumulocity.sdk.client.inventory.ManagedObjectCollection;
import com.cumulocity.sdk.client.inventory.PagedManagedObjectCollectionRepresentation;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.EventListener;

@ComponentScan
public class CodecMicroservice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodecMicroservice.class);
    static final String DEVICE_TYPE_DESCRIPTION_FORMAT = "Device protocol that supports device model '%s' manufactured by '%s'";
    static final String C8Y_SMART_REST_DEVICE_IDENTIFIER = "c8y_SmartRestDeviceIdentifier";
    static final String C8Y_LPWAN_CODEC_DETAILS = "c8y_LpwanCodecDetails";
    static final String FIELDBUS_TYPE = "fieldbusType";
    static final String DESCRIPTION = "description";
    static final String C8Y_IS_DEVICE_TYPE = "c8y_IsDeviceType";
    static final String C8Y_LPWAN_DEVICE_TYPE = "c8y_LpwanDeviceType";
    static final String LPWAN_FIELDBUS_TYPE = "lpwan";
    static final String DEVICE_TYPE_NAME_FORMAT = "%s : %s";
    static final String C8Y_DEVICE_SHELL_TEMPLATE = "c8y_DeviceShellTemplate";
    static final String DEVICE_TYPE = "deviceType";
    static final String COMMAND = "command";
    static final String CATEGORY = "category";
    static final String DELIVERY_TYPES = "deliveryTypes";
    @Autowired
    private ContextService<Credentials> contextService;
    @Autowired
    private PlatformProperties platformProperties;
    @Autowired
    private ApplicationApi applicationApi;
    @Autowired
    private InventoryApi inventoryApi;
    @Autowired
    private IdentityApi identityApi;
    @Autowired
    private Codec codec;
    private volatile String contextPath;

    @EventListener
    void registerDeviceTypes(MicroserviceSubscriptionAddedEvent event) {
        if (Objects.isNull(this.contextPath)) {
            this.contextPath = (String)this.contextService.callWithinContext((Object)this.platformProperties.getMicroserviceBoostrapUser(), () -> {
                try {
                    return this.applicationApi.currentApplication().get().getContextPath();
                }
                catch (Exception e) {
                    log.warn("Error while determining the microservice context path. Defaulting to the application name.", (Throwable)e);
                    return this.platformProperties.getApplicationName();
                }
            });
        }
        this.contextService.runWithinContext((Object)event.getCredentials(), () -> {
            Set<DeviceInfo> supportedDevices = this.codec.supportsDevices();
            for (DeviceInfo supportedDevice : supportedDevices) {
                ManagedObjectRepresentation deviceTypeMo = this.registerDeviceType(supportedDevice);
                if (!Objects.nonNull(deviceTypeMo)) continue;
                this.createPredefinedCommandTemplates(deviceTypeMo, supportedDevice.getSupportedCommands());
            }
        });
    }

    private ManagedObjectRepresentation registerDeviceType(DeviceInfo deviceInfo) {
        try {
            deviceInfo.validate();
        }
        catch (IllegalArgumentException e) {
            log.error("Device manufacturer and model are mandatory fields in the supported device. Skipping the Device Type creation.", (Throwable)e);
            return null;
        }
        String supportedDeviceTypeName = this.formDeviceTypeName(deviceInfo);
        LpwanCodecDetails lpwanCodecDetails = new LpwanCodecDetails(this.contextPath, deviceInfo);
        Optional<ExternalIDRepresentation> deviceType = this.isDeviceTypeExists(deviceInfo);
        ManagedObjectRepresentation deviceTypeMo = null;
        if (!deviceType.isPresent()) {
            log.info("Creating device type '{}' on codec microservice subscription", (Object)supportedDeviceTypeName);
            String description = String.format(DEVICE_TYPE_DESCRIPTION_FORMAT, deviceInfo.getDeviceModel(), deviceInfo.getDeviceManufacturer());
            deviceTypeMo = new ManagedObjectRepresentation();
            deviceTypeMo.setName(supportedDeviceTypeName);
            deviceTypeMo.set((Object)description, DESCRIPTION);
            deviceTypeMo.set((Object)Collections.EMPTY_MAP, C8Y_IS_DEVICE_TYPE);
            deviceTypeMo.setType(C8Y_LPWAN_DEVICE_TYPE);
            deviceTypeMo.set((Object)LPWAN_FIELDBUS_TYPE, FIELDBUS_TYPE);
            deviceTypeMo.set(lpwanCodecDetails.getAttributes(), C8Y_LPWAN_CODEC_DETAILS);
            try {
                deviceTypeMo = this.inventoryApi.create(deviceTypeMo);
                ExternalIDRepresentation deviceTypeExternalId = new ExternalIDRepresentation();
                deviceTypeExternalId.setExternalId(supportedDeviceTypeName);
                deviceTypeExternalId.setType(C8Y_SMART_REST_DEVICE_IDENTIFIER);
                deviceTypeExternalId.setManagedObject(deviceTypeMo);
                try {
                    this.identityApi.create(deviceTypeExternalId);
                }
                catch (Exception e) {
                    log.error("Unable create External Id for device type with name '{}'", (Object)supportedDeviceTypeName, (Object)e);
                    return null;
                }
            }
            catch (Exception e) {
                log.error("Unable create device type with name '{}'", (Object)supportedDeviceTypeName, (Object)e);
                return null;
            }
            log.info("Created device type '{}' on codec microservice subscription", (Object)supportedDeviceTypeName);
        } else {
            log.info("Updating the device type with name '{}' as it already exists", (Object)supportedDeviceTypeName);
            deviceTypeMo = ManagedObjects.asManagedObject((GId)deviceType.get().getManagedObject().getId());
            deviceTypeMo.set(lpwanCodecDetails.getAttributes(), C8Y_LPWAN_CODEC_DETAILS);
            try {
                deviceTypeMo = this.inventoryApi.update(deviceTypeMo);
            }
            catch (Exception e) {
                log.error("Unable update device type with name '{}'", (Object)supportedDeviceTypeName, (Object)e);
                return null;
            }
            log.info("Updated the device type with name '{}' as it already exists", (Object)supportedDeviceTypeName);
        }
        return deviceTypeMo;
    }

    private Optional<ExternalIDRepresentation> isDeviceTypeExists(DeviceInfo deviceInfo) {
        try {
            return Optional.of(this.identityApi.getExternalId(new ID(C8Y_SMART_REST_DEVICE_IDENTIFIER, this.formDeviceTypeName(deviceInfo))));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    String formDeviceTypeName(DeviceInfo deviceInfo) {
        return String.format(DEVICE_TYPE_NAME_FORMAT, deviceInfo.getDeviceManufacturer(), deviceInfo.getDeviceModel());
    }

    private void createPredefinedCommandTemplates(ManagedObjectRepresentation deviceTypeMo, Set<DeviceCommand> supportedCommands) {
        try {
            log.info("Creating predefined command templates for the device type '{}' on codec microservice subscription", (Object)deviceTypeMo.getName());
            PredefinedCommandFilter inventoryFilter = PredefinedCommandFilter.of(C8Y_DEVICE_SHELL_TEMPLATE, DEVICE_TYPE, deviceTypeMo.getName());
            ManagedObjectCollection managedObjectCollection = this.inventoryApi.getManagedObjectsByFilter((InventoryFilter)inventoryFilter);
            Iterable allPredefinedCommands = null;
            if (Objects.nonNull(managedObjectCollection)) {
                allPredefinedCommands = ((PagedManagedObjectCollectionRepresentation)managedObjectCollection.get(new QueryParam[0])).allPages();
            }
            if (Objects.nonNull(allPredefinedCommands)) {
                for (ManagedObjectRepresentation predefinedCommand : allPredefinedCommands) {
                    this.inventoryApi.delete(predefinedCommand.getId());
                    log.debug("Deleted existing predefined command template '{}' for the device type '{}'", (Object)predefinedCommand.getName(), (Object)deviceTypeMo.getName());
                }
            }
            if (Objects.nonNull(supportedCommands)) {
                for (DeviceCommand oneSupportedCommand : supportedCommands) {
                    ManagedObjectRepresentation predefinedCommand = new ManagedObjectRepresentation();
                    predefinedCommand.setName(oneSupportedCommand.getName());
                    predefinedCommand.setType(C8Y_DEVICE_SHELL_TEMPLATE);
                    predefinedCommand.set((Object)new String[]{deviceTypeMo.getName()}, DEVICE_TYPE);
                    predefinedCommand.set((Object)oneSupportedCommand.getCommand(), COMMAND);
                    predefinedCommand.set((Object)oneSupportedCommand.getCategory(), CATEGORY);
                    predefinedCommand.set((Object)new String[]{"Default"}, DELIVERY_TYPES);
                    try {
                        this.inventoryApi.create(predefinedCommand);
                        log.info("Created predefined command template '{}' for device type '{}'", (Object)predefinedCommand.getName(), (Object)deviceTypeMo.getName());
                    }
                    catch (Exception e) {
                        log.error("Failed to create the predefined command named '{}', for the device type '{}'", (Object)oneSupportedCommand.getName(), (Object)deviceTypeMo.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to create the predefined commands for the device type '{}'", (Object)deviceTypeMo.getName());
        }
    }
}

