/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.handler;

import com.cumulocity.microservice.customdecoders.api.exception.DecoderServiceException;
import com.cumulocity.microservice.customdecoders.api.exception.InvalidInputDataException;
import com.cumulocity.microservice.customdecoders.api.model.DecoderResult;
import com.cumulocity.microservice.customencoders.api.exception.EncoderServiceException;
import com.cumulocity.microservice.customencoders.api.exception.InvalidCommandDataException;
import com.cumulocity.microservice.customencoders.api.model.EncoderResult;
import com.cumulocity.rest.representation.ErrorDetails;
import com.cumulocity.rest.representation.ErrorMessageRepresentation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class CodecExceptionsHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodecExceptionsHandler.class);

    @ExceptionHandler(value={DecoderServiceException.class})
    @ResponseBody
    public ResponseEntity<DecoderResult> handleDecoderServiceException(DecoderServiceException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        HttpStatus httpStatus = exception.getCause() instanceof UnsupportedOperationException ? HttpStatus.NOT_IMPLEMENTED : (exception instanceof InvalidInputDataException ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR);
        return ResponseEntity.status((HttpStatusCode)httpStatus).contentType(MediaType.APPLICATION_JSON).body((Object)exception.getResult());
    }

    @ExceptionHandler(value={EncoderServiceException.class})
    @ResponseBody
    public ResponseEntity<EncoderResult> handleEncoderServiceException(EncoderServiceException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        HttpStatus httpStatus = exception.getCause() instanceof UnsupportedOperationException ? HttpStatus.NOT_IMPLEMENTED : (exception instanceof InvalidCommandDataException ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR);
        return ResponseEntity.status((HttpStatusCode)httpStatus).contentType(MediaType.APPLICATION_JSON).body((Object)exception.getResult());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ResponseEntity<ErrorMessageRepresentation> handleIllegalArgumentException(Throwable exception) {
        log.error(exception.getMessage(), exception);
        return this.buildErrorResponse(exception, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<ErrorMessageRepresentation> buildErrorResponse(Throwable exception, HttpStatus status) {
        ErrorMessageRepresentation representation = this.buildErrorMessageRepresentation(exception);
        return ResponseEntity.status((HttpStatusCode)status).contentType(MediaType.parseMediaType((String)"application/vnd.com.nsn.cumulocity.error+json;charset=UTF-8;ver=0.9")).body((Object)representation);
    }

    private ErrorMessageRepresentation buildErrorMessageRepresentation(Throwable exception) {
        ErrorMessageRepresentation representation = new ErrorMessageRepresentation();
        representation.setError("Codec Microservice Error");
        representation.setMessage(exception.getMessage());
        representation.setDetails(this.buildErrorDetails(exception));
        return representation;
    }

    private ErrorDetails buildErrorDetails(Throwable exception) {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setExpectionClass(exception.getClass().getCanonicalName());
        errorDetails.setExceptionMessage(exception.getMessage());
        return errorDetails;
    }
}

