/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.encoder.model;

import com.cumulocity.microservice.customencoders.api.model.EncoderInputData;
import com.cumulocity.microservice.lpwan.codec.model.DeviceInfo;
import com.cumulocity.model.idtype.GId;
import com.google.common.base.Strings;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LpwanEncoderInputData
extends EncoderInputData {
    public static final String SOURCE_DEVICE_EUI_KEY = "sourceDeviceEui";

    public LpwanEncoderInputData(@NotBlank String sourceDeviceId, @NotBlank String sourceDeviceEui, @NotNull DeviceInfo sourceDeviceInfo, @NotBlank String commandName, @Null String commandData) {
        this.initializeAndValidate(sourceDeviceId, sourceDeviceEui, sourceDeviceInfo, commandName, commandData, null);
    }

    public LpwanEncoderInputData(@NotBlank GId sourceDeviceId, @NotBlank String commandName, @Null String commandData, @NotNull Map<String, String> args) {
        String sourceDeviceIdString = null;
        if (Objects.nonNull(sourceDeviceId)) {
            sourceDeviceIdString = sourceDeviceId.getValue();
        }
        String sourceDeviceEui = null;
        DeviceInfo sourceDeviceInfo = null;
        if (Objects.nonNull(args)) {
            sourceDeviceEui = args.get(SOURCE_DEVICE_EUI_KEY);
            sourceDeviceInfo = new DeviceInfo(args);
        }
        this.initializeAndValidate(sourceDeviceIdString, sourceDeviceEui, sourceDeviceInfo, commandName, commandData, args);
    }

    private void initializeAndValidate(@NotBlank String sourceDeviceId, @NotBlank String sourceDeviceEui, @NotNull DeviceInfo sourceDeviceInfo, @NotBlank String commandName, @Null String commandData, @Null Map<String, String> inputArguments) {
        this.setSourceDeviceId(sourceDeviceId);
        this.setSourceDeviceEui(sourceDeviceEui);
        this.setSourceDeviceInfo(sourceDeviceInfo);
        this.setCommandName(commandName);
        this.setCommandData(commandData);
        if (Objects.nonNull(inputArguments)) {
            this.getInputArguments().putAll(inputArguments);
        }
        this.validate();
    }

    @NotBlank
    public String getSourceDeviceEui() {
        return this.getInputArguments().get(SOURCE_DEVICE_EUI_KEY);
    }

    private void setSourceDeviceEui(@NotBlank String sourceDeviceEui) {
        this.getInputArguments().put(SOURCE_DEVICE_EUI_KEY, sourceDeviceEui);
    }

    @NotNull
    public DeviceInfo getSourceDeviceInfo() {
        return new DeviceInfo(this.getInputArguments());
    }

    private void setSourceDeviceInfo(@NotNull DeviceInfo sourceDeviceInfo) {
        if (Objects.nonNull(sourceDeviceInfo)) {
            this.getInputArguments().put("deviceManufacturer", sourceDeviceInfo.getDeviceManufacturer());
            this.getInputArguments().put("deviceModel", sourceDeviceInfo.getDeviceModel());
        }
    }

    @NotNull
    private Map<String, String> getInputArguments() {
        HashMap args = super.getArgs();
        if (Objects.isNull(args)) {
            args = new HashMap();
            this.setArgs(args);
        }
        return args;
    }

    private void validate() {
        ArrayList<String> missingParameters = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)this.getSourceDeviceId())) {
            missingParameters.add("'sourceDeviceId'");
        }
        if (Strings.isNullOrEmpty((String)this.getSourceDeviceEui())) {
            missingParameters.add("'sourceDeviceEui'");
        }
        if (Objects.isNull(this.getSourceDeviceInfo())) {
            missingParameters.add("'sourceDeviceInfo'");
        } else {
            try {
                this.getSourceDeviceInfo().validate();
            }
            catch (IllegalArgumentException e) {
                missingParameters.add("'manufacturer, model and/or supportedCommands'");
            }
        }
        if (Strings.isNullOrEmpty((String)this.getCommandName())) {
            missingParameters.add("'commandName'");
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("EncoderInputData is missing mandatory fields: " + String.join((CharSequence)", ", missingParameters));
        }
    }
}

