/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.lpwan.codec.decoder.model;

import com.cumulocity.microservice.customdecoders.api.model.DecoderInputData;
import com.cumulocity.microservice.lpwan.codec.model.DeviceInfo;
import com.cumulocity.model.idtype.GId;
import com.google.common.base.Strings;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LpwanDecoderInputData
extends DecoderInputData {
    public static final String SOURCE_DEVICE_EUI_KEY = "sourceDeviceEui";
    public static final String FPORT_KEY = "fport";
    public static final String UPDATE_TIME_KEY = "updateTime";

    public LpwanDecoderInputData(@NotBlank String sourceDeviceId, @NotBlank String sourceDeviceEui, @NotNull DeviceInfo sourceDeviceInfo, @NotBlank String inputData, @Null Integer fport, @Null Long updateTime) {
        this.initializeAndValidate(sourceDeviceId, sourceDeviceEui, sourceDeviceInfo, inputData, fport, updateTime, null);
    }

    public LpwanDecoderInputData(@NotBlank String inputData, @NotNull GId sourceDeviceId, @NotNull Map<String, String> args) {
        String sourceDeviceIdString = null;
        if (Objects.nonNull(sourceDeviceId)) {
            sourceDeviceIdString = sourceDeviceId.getValue();
        }
        String sourceDeviceEui = null;
        DeviceInfo sourceDeviceInfo = null;
        Integer fport = null;
        Long updateTime = null;
        if (Objects.nonNull(args)) {
            String fportstring;
            sourceDeviceEui = args.get(SOURCE_DEVICE_EUI_KEY);
            sourceDeviceInfo = new DeviceInfo(args);
            String updateTimeString = args.get(UPDATE_TIME_KEY);
            if (!Strings.isNullOrEmpty((String)updateTimeString)) {
                try {
                    updateTime = Long.valueOf(updateTimeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!Strings.isNullOrEmpty((String)(fportstring = args.get(FPORT_KEY)))) {
                try {
                    fport = Integer.valueOf(fportstring);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        this.initializeAndValidate(sourceDeviceIdString, sourceDeviceEui, sourceDeviceInfo, inputData, fport, updateTime, args);
    }

    private void initializeAndValidate(@NotBlank String sourceDeviceId, @NotBlank String sourceDeviceEui, @NotNull DeviceInfo sourceDeviceInfo, @NotBlank String inputData, @Null Integer fport, @Null Long updateTime, @Null Map<String, String> inputArguments) {
        this.setSourceDeviceId(sourceDeviceId);
        this.setSourceDeviceEui(sourceDeviceEui);
        this.setSourceDeviceInfo(sourceDeviceInfo);
        this.setValue(inputData);
        this.setFport(fport);
        this.setUpdateTime(updateTime);
        if (Objects.nonNull(inputArguments)) {
            this.getInputArguments().putAll(inputArguments);
        }
        this.validate();
    }

    @NotBlank
    public String getSourceDeviceEui() {
        return this.getInputArguments().get(SOURCE_DEVICE_EUI_KEY);
    }

    private void setSourceDeviceEui(@NotBlank String sourceDeviceEui) {
        this.getInputArguments().put(SOURCE_DEVICE_EUI_KEY, sourceDeviceEui);
    }

    @NotNull
    public DeviceInfo getSourceDeviceInfo() {
        return new DeviceInfo(this.getInputArguments());
    }

    private void setSourceDeviceInfo(@NotNull DeviceInfo sourceDeviceInfo) {
        if (Objects.nonNull(sourceDeviceInfo)) {
            this.getInputArguments().put("deviceManufacturer", sourceDeviceInfo.getDeviceManufacturer());
            this.getInputArguments().put("deviceModel", sourceDeviceInfo.getDeviceModel());
        }
    }

    @Null
    public Long getUpdateTime() {
        String updateTimeString = this.getInputArguments().get(UPDATE_TIME_KEY);
        if (!Strings.isNullOrEmpty((String)updateTimeString)) {
            return Long.valueOf(updateTimeString);
        }
        return null;
    }

    private void setUpdateTime(@Null Long updateTime) {
        if (Objects.nonNull(updateTime)) {
            this.getInputArguments().put(UPDATE_TIME_KEY, updateTime.toString());
        }
    }

    @Null
    public Integer getFport() {
        String fportstring = this.getInputArguments().get(FPORT_KEY);
        if (!Strings.isNullOrEmpty((String)fportstring)) {
            return Integer.valueOf(fportstring);
        }
        return null;
    }

    private void setFport(@Null Integer fport) {
        if (Objects.nonNull(fport)) {
            this.getInputArguments().put(FPORT_KEY, fport.toString());
        }
    }

    @NotNull
    private Map<String, String> getInputArguments() {
        HashMap args = super.getArgs();
        if (Objects.isNull(args)) {
            args = new HashMap();
            this.setArgs(args);
        }
        return args;
    }

    private void validate() {
        ArrayList<String> missingParameters = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)this.getSourceDeviceId())) {
            missingParameters.add("'sourceDeviceId'");
        }
        if (Strings.isNullOrEmpty((String)this.getSourceDeviceEui())) {
            missingParameters.add("'sourceDeviceEui'");
        }
        if (Strings.isNullOrEmpty((String)this.getValue())) {
            missingParameters.add("'inputData'");
        }
        if (Objects.isNull(this.getSourceDeviceInfo())) {
            missingParameters.add("'sourceDeviceInfo'");
        } else {
            try {
                this.getSourceDeviceInfo().validate();
            }
            catch (IllegalArgumentException e) {
                missingParameters.add("'manufacturer and/or model'");
            }
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("DecoderInputData is missing mandatory fields: " + String.join((CharSequence)", ", missingParameters));
        }
    }
}

