/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.sdk.services.client;

import com.cumulocity.email.client.EmailApi;
import com.cumulocity.email.client.EmailApiImpl;
import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.sdk.services.client.ServicesPlatform;
import com.cumulocity.sms.client.SmsMessagingApi;
import com.cumulocity.sms.client.SmsMessagingApiImpl;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.fluent.Executor;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesPlatformImpl
implements ServicesPlatform {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServicesPlatformImpl.class);
    private final String host;
    private final Executor executor;

    public ServicesPlatformImpl(String host, final CumulocityBasicCredentials credentials) {
        this(host, new CredentialsProvider(){

            @Override
            public String getTenant() {
                return credentials.getTenantId();
            }

            @Override
            public String getUsername() {
                return credentials.getUsername();
            }

            @Override
            public String getPassword() {
                return credentials.getPassword();
            }
        });
    }

    public ServicesPlatformImpl(String host, CredentialsProvider auth) {
        if (((String)host).charAt(((String)host).length() - 1) != '/') {
            host = (String)host + "/";
        }
        this.host = host;
        this.executor = ServicesPlatformImpl.createExecutor((String)host, auth);
    }

    @Override
    public SmsMessagingApi getSmsMessagingApi() {
        return new SmsMessagingApiImpl(this.host, this.executor);
    }

    @Override
    public EmailApi getEmailApi() {
        return new EmailApiImpl(this.host, this.executor);
    }

    private static Executor createExecutor(String url, final CredentialsProvider auth) {
        return Executor.newInstance().use((org.apache.http.client.CredentialsProvider)new BasicCredentialsProvider(){

            public Credentials getCredentials(AuthScope authscope) {
                return new UsernamePasswordCredentials(auth.getTenant() + "/" + auth.getUsername(), auth.getPassword());
            }
        }).authPreemptive(ServicesPlatformImpl.getHost(url));
    }

    private static HttpHost getHost(String host) {
        URL url;
        try {
            url = new URL(host);
        }
        catch (MalformedURLException e) {
            log.error("Invalid url string", (Throwable)e);
            throw new IllegalArgumentException("Missing or invalid protocol information, or else wrong format/encoding of provided address: " + host);
        }
        return new HttpHost(url.getHost(), url.getPort());
    }

    public static interface CredentialsProvider {
        public String getTenant();

        public String getUsername();

        public String getPassword();
    }
}

