/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation.tenant;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.IDTypeConverter;
import com.cumulocity.model.JSONBase;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.CustomPropertiesMapRepresentation;
import com.cumulocity.rest.representation.application.ApplicationReferenceCollectionRepresentation;
import com.cumulocity.rest.representation.tenant.SupportUserDetailsRepresentation;
import com.google.common.base.MoreObjects;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.joda.time.DateTime;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public class TenantRepresentation
extends CustomPropertiesMapRepresentation {
    private String id;
    @Size(max=256)
    private @Size(max=256) String domain;
    @Pattern(regexp="ACTIVE|SUSPENDED")
    private @Pattern(regexp="ACTIVE|SUSPENDED") String status;
    @Size(max=256)
    private @Size(max=256) String company;
    @Size(max=50)
    private @Size(max=50) String adminName;
    @Size(max=32)
    private @Size(max=32) String adminPass;
    private String adminEmail;
    @Size(max=30)
    private @Size(max=30) String contactName;
    private String contactPhone;
    private ApplicationReferenceCollectionRepresentation applications;
    private ApplicationReferenceCollectionRepresentation ownedApplications;
    private Boolean sendPasswordResetEmail;
    private DateTime dateCreated;
    private SupportUserDetailsRepresentation supportUser;
    @Size(max=32)
    private @Size(max=32) String parent;
    private Boolean allowCreateTenants;
    private Long storageLimitPerDevice;
    private GId tenantPolicyId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @JSONProperty(ignoreIfNull=true)
    public ApplicationReferenceCollectionRepresentation getApplications() {
        return this.applications;
    }

    public void setApplications(ApplicationReferenceCollectionRepresentation applications) {
        this.applications = applications;
    }

    @JSONProperty(ignoreIfNull=true)
    public ApplicationReferenceCollectionRepresentation getOwnedApplications() {
        return this.ownedApplications;
    }

    public void setOwnedApplications(ApplicationReferenceCollectionRepresentation ownedApplications) {
        this.ownedApplications = ownedApplications;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getAdminPass() {
        return this.adminPass;
    }

    public void setAdminPass(String adminPass) {
        this.adminPass = adminPass;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getSendPasswordResetEmail() {
        return this.sendPasswordResetEmail;
    }

    @JSONProperty(ignore=true)
    public boolean shouldSendPasswordResetEmail() {
        return (Boolean)MoreObjects.firstNonNull((Object)this.sendPasswordResetEmail, (Object)false);
    }

    public void setSendPasswordResetEmail(Boolean sendPasswordResetEmail) {
        this.sendPasswordResetEmail = sendPasswordResetEmail;
    }

    @JSONProperty(ignoreIfNull=true)
    public SupportUserDetailsRepresentation getSupportUser() {
        return this.supportUser;
    }

    public void setSupportUser(SupportUserDetailsRepresentation supportUser) {
        this.supportUser = supportUser;
    }

    @JSONProperty(value="deprecated_DateCreated", ignore=true)
    @Deprecated
    public Date getDateCreated() {
        return this.dateCreated == null ? null : this.dateCreated.toDate();
    }

    @JSONProperty(value="creationTime", ignoreIfNull=true)
    @JSONConverter(type=DateTimeConverter.class)
    public DateTime getCreatedDateTime() {
        return this.dateCreated;
    }

    public void setCreatedDateTime(DateTime dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public String toJSON() {
        return JSONBase.getJSONGenerator().forValue((Object)this);
    }

    @JSONProperty(ignoreIfNull=true)
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getAllowCreateTenants() {
        return this.allowCreateTenants;
    }

    public void setAllowCreateTenants(Boolean allowCreateTenants) {
        this.allowCreateTenants = allowCreateTenants;
    }

    @JSONProperty(ignoreIfNull=true)
    public Long getStorageLimitPerDevice() {
        return this.storageLimitPerDevice;
    }

    public void setStorageLimitPerDevice(Long storageLimitPerDevice) {
        this.storageLimitPerDevice = storageLimitPerDevice;
    }

    public void setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONConverter(type=IDTypeConverter.class)
    public GId getTenantPolicyId() {
        return this.tenantPolicyId;
    }

    public void setTenantPolicyId(GId tenantPolicyId) {
        this.tenantPolicyId = tenantPolicyId;
    }
}

