/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.Document;
import com.cumulocity.model.DynamicPropertiesFilter;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.svenson.AbstractDynamicProperties;

public class DocumentTest {
    @Test
    public void shouldCopyAllDynamicProperties() {
        Document source = new Document(){};
        source.set((Object)"dynamic_property_value", "dynamic_property_name");
        Document target = new Document(){};
        Document.copyDynamicProperties((AbstractDynamicProperties)source, (AbstractDynamicProperties)target);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)target.propertyNames()).isNotEmpty()).contains((Object[])new String[]{"dynamic_property_name"});
        ((ObjectAssert)Assertions.assertThat((Object)target.get("dynamic_property_name")).isNotNull()).isEqualTo(source.get("dynamic_property_name"));
    }

    @Test
    public void shouldNotCopyAnyDynamicProperties() {
        Document source = new Document(){};
        source.set((Object)"dynamic_property_value", "dynamic_property_name");
        Document target = new Document(){};
        Document.copyDynamicProperties((AbstractDynamicProperties)source, (AbstractDynamicProperties)target, (DynamicPropertiesFilter)new DynamicPropertiesFilter(){

            public boolean apply(String name) {
                return false;
            }
        });
        Assertions.assertThat((Collection)target.propertyNames()).isEmpty();
        Assertions.assertThat((Object)target.get("dynamic_property_name")).isNull();
    }

    @Test
    public void shouldNotCopyFiltredDynamicProperties() {
        Document source = new Document(){};
        source.set((Object)"dynamic_property_value", "dynamic_property_name");
        source.set((Object)"otner_dynamic_property_value", "otner_dynamic_property_name");
        Document target = new Document(){};
        Document.copyDynamicProperties((AbstractDynamicProperties)source, (AbstractDynamicProperties)target, (DynamicPropertiesFilter)new DynamicPropertiesFilter(){

            public boolean apply(String name) {
                return name.equals("dynamic_property_name");
            }
        });
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)target.propertyNames()).isNotEmpty()).contains((Object[])new String[]{"dynamic_property_name"});
        ((ObjectAssert)Assertions.assertThat((Object)target.get("dynamic_property_name")).isNotNull()).isEqualTo(source.get("dynamic_property_name"));
    }

    @Test
    public void shouldCopyDynamicPropertiesDeeply() {
        Document nestedObject = new Document(){};
        nestedObject.setProperty("c8y.NestedObject", (Object)ImmutableMap.of((Object)"value", (Object)7));
        ImmutableMap nestedMap = ImmutableMap.of((Object)"c8y.Measurement", (Object)ImmutableMap.of((Object)"value", (Object)42));
        Document source = new Document(){};
        source.setProperty("c8y.SimpleProperty", (Object)"value");
        source.setProperty("c8y.CustomProperty", (Object)nestedMap);
        source.setProperty("c8y.CustomNestedObject", (Object)nestedObject);
        source.setProperty("c8y.NullProperty", null);
        Document copy = (Document)Document.deepCopyDynamicProperties((AbstractDynamicProperties)source, (AbstractDynamicProperties)new Document(){});
        Assertions.assertThat((Object)copy).isEqualTo((Object)source);
        Assertions.assertThat((Object)copy.get("c8y.CustomNestedObject")).isNotSameAs((Object)nestedObject);
        Assertions.assertThat((Object)copy.get("c8y.CustomProperty")).isNotSameAs((Object)nestedMap);
    }
}

