/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation.tenant;

import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import jakarta.validation.constraints.Size;
import org.svenson.JSONProperty;

public class OptionRepresentation
extends AbstractExtensibleRepresentation {
    @Size(max=256)
    private @Size(max=256) String category;
    @Size(max=256)
    private @Size(max=256) String key;
    private String value;

    public static OptionRepresentation asOptionRepresentation(String category, String key, String value) {
        OptionRepresentation optionRepresentation = new OptionRepresentation();
        optionRepresentation.setKey(key);
        optionRepresentation.setValue(value);
        optionRepresentation.setCategory(category);
        return optionRepresentation;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JSONProperty(ignore=true)
    public boolean isTrue() {
        return "true".equalsIgnoreCase(this.getValue());
    }

    @JSONProperty(ignore=true)
    public boolean isFalse() {
        return !this.isTrue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionRepresentation other = (OptionRepresentation)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

