/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation;

import com.cumulocity.rest.representation.BaseResourceRepresentation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.svenson.JSON;
import org.svenson.JSONParser;

class BaseResourceRepresentationSerializationTest {
    private static final String REPRESENTATION_JSON = "{\"self\":\"selfExample\"}";
    private static final String REPRESENTATION_JSON_EXTRA_UNKNOWN_FIELD = "{\"self\":\"selfExample\",\"my_property\":\"my_value\"}";
    private static final String REPRESENTATION_JSON_WITH_SELF_DECODED = "{\"self\":\"selfExample\",\"selfDecoded\":null}";
    private final JSONParser jsonParser = new JSONParser();
    private final JSON jsonGenerator = new JSON();

    BaseResourceRepresentationSerializationTest() {
    }

    @Test
    public final void shouldDeserialize() {
        BaseResourceRepresentation representation = (BaseResourceRepresentation)this.jsonParser.parse(BaseResourceRepresentation.class, REPRESENTATION_JSON);
        Assertions.assertThat((Object)representation).isNotNull();
        Assertions.assertThat((String)representation.getSelf()).isEqualTo("selfExample");
        Assertions.assertThat((String)representation.getSelfDecoded()).isEqualTo("selfExample");
    }

    @Test
    public final void shouldDeserializeWithSelfDecodedField() {
        BaseResourceRepresentation representation = (BaseResourceRepresentation)this.jsonParser.parse(BaseResourceRepresentation.class, REPRESENTATION_JSON_WITH_SELF_DECODED);
        Assertions.assertThat((Object)representation).isNotNull();
        Assertions.assertThat((String)representation.getSelf()).isEqualTo("selfExample");
        Assertions.assertThat((String)representation.getSelfDecoded()).isEqualTo("selfExample");
    }

    @Test
    public final void shouldDeserializeWithUnknownExtraField() {
        BaseResourceRepresentation representation = (BaseResourceRepresentation)this.jsonParser.parse(BaseResourceRepresentation.class, REPRESENTATION_JSON_EXTRA_UNKNOWN_FIELD);
        Assertions.assertThat((Object)representation).isNotNull();
        Assertions.assertThat((String)representation.getSelf()).isEqualTo("selfExample");
        Assertions.assertThat((String)representation.getSelfDecoded()).isEqualTo("selfExample");
    }

    @Test
    public final void shouldSerialize() {
        BaseResourceRepresentation representation = new BaseResourceRepresentation();
        representation.setSelf("selfExample");
        String json = this.jsonGenerator.forValue((Object)representation);
        Assertions.assertThat((String)json).isEqualTo(REPRESENTATION_JSON);
    }
}

