/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.email;

import com.cumulocity.model.email.Attachment;
import com.cumulocity.model.email.Email;

public class EmailBuilder {
    private String[] to;
    private String replyTo;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String text;
    private Attachment[] attachments;

    public static EmailBuilder aEmail() {
        return new EmailBuilder();
    }

    public EmailBuilder withTo(String ... to) {
        this.to = to;
        return this;
    }

    public EmailBuilder withCc(String ... cc) {
        this.cc = cc;
        return this;
    }

    public EmailBuilder withBcc(String ... bcc) {
        this.bcc = bcc;
        return this;
    }

    public EmailBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public EmailBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public EmailBuilder withReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public EmailBuilder withAttachments(Attachment ... attachments) {
        this.attachments = attachments;
        return this;
    }

    public Email build() {
        Email result = new Email();
        result.setTo(this.to);
        result.setReplyTo(this.replyTo);
        result.setCc(this.cc);
        result.setBcc(this.bcc);
        result.setSubject(this.subject);
        result.setText(this.text);
        result.setAttachments(this.attachments);
        return result;
    }
}

