/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.email;

import com.cumulocity.model.email.Attachment;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Email.class);
    private String replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String text;
    private Attachment[] attachments;

    public Email(Email email) {
        this.replyTo = email.getReplyTo();
        this.to = (String[])email.getTo().clone();
        this.cc = (String[])email.getCc().clone();
        this.bcc = (String[])email.getBcc().clone();
        this.subject = email.getSubject();
        this.text = email.getText();
        this.attachments = (Attachment[])email.getAttachments().clone();
    }

    public String toString() {
        return "Email [replyTo=" + this.replyTo + ", to=" + Arrays.toString(this.to) + ", cc=" + Arrays.toString(this.cc) + ", bcc=" + Arrays.toString(this.bcc) + ", subject=" + this.subject + ", text=" + this.text + ", attachments=" + Arrays.toString(this.attachments) + "]";
    }

    @Override
    public void close() {
        if (this.attachments != null) {
            for (Attachment attachment : this.attachments) {
                try {
                    attachment.close();
                }
                catch (IOException e) {
                    log.warn("Error while closing email attachment", (Throwable)e);
                }
            }
        }
    }

    @Generated
    public String getReplyTo() {
        return this.replyTo;
    }

    @Generated
    public String[] getTo() {
        return this.to;
    }

    @Generated
    public String[] getCc() {
        return this.cc;
    }

    @Generated
    public String[] getBcc() {
        return this.bcc;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public Attachment[] getAttachments() {
        return this.attachments;
    }

    @Generated
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    @Generated
    public void setTo(String[] to) {
        this.to = to;
    }

    @Generated
    public void setCc(String[] cc) {
        this.cc = cc;
    }

    @Generated
    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setAttachments(Attachment[] attachments) {
        this.attachments = attachments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email other = (Email)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$replyTo = this.getReplyTo();
        String other$replyTo = other.getReplyTo();
        if (this$replyTo == null ? other$replyTo != null : !this$replyTo.equals(other$replyTo)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTo(), other.getTo())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCc(), other.getCc())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBcc(), other.getBcc())) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        return Arrays.deepEquals(this.getAttachments(), other.getAttachments());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Email;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $replyTo = this.getReplyTo();
        result = result * 59 + ($replyTo == null ? 43 : $replyTo.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTo());
        result = result * 59 + Arrays.deepHashCode(this.getCc());
        result = result * 59 + Arrays.deepHashCode(this.getBcc());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAttachments());
        return result;
    }

    @Generated
    public Email withReplyTo(String replyTo) {
        return this.replyTo == replyTo ? this : new Email(replyTo, this.to, this.cc, this.bcc, this.subject, this.text, this.attachments);
    }

    @Generated
    public Email withTo(String[] to) {
        return this.to == to ? this : new Email(this.replyTo, to, this.cc, this.bcc, this.subject, this.text, this.attachments);
    }

    @Generated
    public Email withCc(String[] cc) {
        return this.cc == cc ? this : new Email(this.replyTo, this.to, cc, this.bcc, this.subject, this.text, this.attachments);
    }

    @Generated
    public Email withBcc(String[] bcc) {
        return this.bcc == bcc ? this : new Email(this.replyTo, this.to, this.cc, bcc, this.subject, this.text, this.attachments);
    }

    @Generated
    public Email withSubject(String subject) {
        return this.subject == subject ? this : new Email(this.replyTo, this.to, this.cc, this.bcc, subject, this.text, this.attachments);
    }

    @Generated
    public Email withText(String text) {
        return this.text == text ? this : new Email(this.replyTo, this.to, this.cc, this.bcc, this.subject, text, this.attachments);
    }

    @Generated
    public Email withAttachments(Attachment[] attachments) {
        return this.attachments == attachments ? this : new Email(this.replyTo, this.to, this.cc, this.bcc, this.subject, this.text, attachments);
    }

    @Generated
    public Email() {
    }

    @Generated
    public Email(String replyTo, String[] to, String[] cc, String[] bcc, String subject, String text, Attachment[] attachments) {
        this.replyTo = replyTo;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
        this.attachments = attachments;
    }
}

