/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.authentication;

import com.cumulocity.model.authentication.AuthenticationMethod;
import com.cumulocity.model.authentication.CumulocityCredentials;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.svenson.JSONParser;

public class CumulocityOAuthCredentials
implements CumulocityCredentials {
    public static final String CUMULOCITY_USER_ID_CLAIM = "sub";
    public static final String TENANT_ID_CLAIM = "ten";
    private final String oAuthAccessToken;
    private final Map<String, Object> accessTokenHeader = new HashMap<String, Object>();
    private final Map<String, Object> accessTokenClaims = new HashMap<String, Object>();
    private String xsrfToken;
    private String applicationKey;
    private String requestOrigin;
    private AuthenticationMethod authenticationMethod;
    private String tenantId;
    private String username;

    public CumulocityOAuthCredentials(String oAuthAccessToken, String xsrfToken, String applicationKey, String requestOrigin, AuthenticationMethod authenticationMethod) {
        this.oAuthAccessToken = oAuthAccessToken;
        this.xsrfToken = xsrfToken;
        this.applicationKey = applicationKey;
        this.requestOrigin = requestOrigin;
        this.authenticationMethod = authenticationMethod != null ? authenticationMethod : AuthenticationMethod.COOKIE;
        this.parseAccessToken();
    }

    private static CumulocityOAuthCredentials create(String oAuthAccessToken, String xsrfToken, String applicationKey, String requestOrigin, AuthenticationMethod authenticationMethod, String tenantId, String username) {
        CumulocityOAuthCredentials oAuthCredentials = new CumulocityOAuthCredentials(oAuthAccessToken, xsrfToken, applicationKey, requestOrigin, authenticationMethod);
        oAuthCredentials.tenantId = tenantId;
        oAuthCredentials.username = username;
        return oAuthCredentials;
    }

    private void parseAccessToken() {
        String[] headerAndClaims = this.oAuthAccessToken.split("\\.");
        this.accessTokenHeader.putAll(this.parseAccessTokenFragment(headerAndClaims[0]));
        this.accessTokenClaims.putAll(this.parseAccessTokenFragment(headerAndClaims[1]));
    }

    private Map<String, Object> parseAccessTokenFragment(String tokenFragment) {
        return (Map)JSONParser.defaultJSONParser().parse(Map.class, new String(Base64.decodeBase64((String)tokenFragment)));
    }

    @Override
    public String getAuthenticationString() {
        switch (this.authenticationMethod) {
            case COOKIE: {
                return this.oAuthAccessToken;
            }
            case HEADER: {
                return "Bearer " + this.oAuthAccessToken;
            }
        }
        return null;
    }

    @Override
    public String getUsername() {
        return Optional.ofNullable(this.accessTokenClaims.get(CUMULOCITY_USER_ID_CLAIM)).map(String::valueOf).orElse(this.username);
    }

    @Override
    public String getTenantId() {
        return Stream.of(this.accessTokenClaims, this.accessTokenHeader).filter(m -> m.containsKey(TENANT_ID_CLAIM)).map(m -> m.get(TENANT_ID_CLAIM)).map(String::valueOf).findFirst().orElse(this.tenantId);
    }

    @Override
    public CumulocityCredentials copy() {
        return CumulocityOAuthCredentials.builder().oAuthAccessToken(this.getAuthenticationString()).xsrfToken(this.getXsrfToken()).requestOrigin(this.getRequestOrigin()).applicationKey(this.getApplicationKey()).authenticationMethod(this.getAuthenticationMethod()).tenantId(this.getTenantId()).username(this.getUsername()).build();
    }

    @Override
    public <T> T accept(CumulocityCredentials.CumulocityCredentialsVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getAccessToken() {
        return this.oAuthAccessToken;
    }

    @Generated
    public static CumulocityOAuthCredentialsBuilder builder() {
        return new CumulocityOAuthCredentialsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CumulocityOAuthCredentials)) {
            return false;
        }
        CumulocityOAuthCredentials other = (CumulocityOAuthCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oAuthAccessToken = this.oAuthAccessToken;
        String other$oAuthAccessToken = other.oAuthAccessToken;
        if (this$oAuthAccessToken == null ? other$oAuthAccessToken != null : !this$oAuthAccessToken.equals(other$oAuthAccessToken)) {
            return false;
        }
        Map<String, Object> this$accessTokenHeader = this.accessTokenHeader;
        Map<String, Object> other$accessTokenHeader = other.accessTokenHeader;
        if (this$accessTokenHeader == null ? other$accessTokenHeader != null : !((Object)this$accessTokenHeader).equals(other$accessTokenHeader)) {
            return false;
        }
        Map<String, Object> this$accessTokenClaims = this.accessTokenClaims;
        Map<String, Object> other$accessTokenClaims = other.accessTokenClaims;
        if (this$accessTokenClaims == null ? other$accessTokenClaims != null : !((Object)this$accessTokenClaims).equals(other$accessTokenClaims)) {
            return false;
        }
        String this$xsrfToken = this.getXsrfToken();
        String other$xsrfToken = other.getXsrfToken();
        if (this$xsrfToken == null ? other$xsrfToken != null : !this$xsrfToken.equals(other$xsrfToken)) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        String this$requestOrigin = this.getRequestOrigin();
        String other$requestOrigin = other.getRequestOrigin();
        if (this$requestOrigin == null ? other$requestOrigin != null : !this$requestOrigin.equals(other$requestOrigin)) {
            return false;
        }
        AuthenticationMethod this$authenticationMethod = this.getAuthenticationMethod();
        AuthenticationMethod other$authenticationMethod = other.getAuthenticationMethod();
        if (this$authenticationMethod == null ? other$authenticationMethod != null : !((Object)((Object)this$authenticationMethod)).equals((Object)other$authenticationMethod)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CumulocityOAuthCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oAuthAccessToken = this.oAuthAccessToken;
        result = result * 59 + ($oAuthAccessToken == null ? 43 : $oAuthAccessToken.hashCode());
        Map<String, Object> $accessTokenHeader = this.accessTokenHeader;
        result = result * 59 + ($accessTokenHeader == null ? 43 : ((Object)$accessTokenHeader).hashCode());
        Map<String, Object> $accessTokenClaims = this.accessTokenClaims;
        result = result * 59 + ($accessTokenClaims == null ? 43 : ((Object)$accessTokenClaims).hashCode());
        String $xsrfToken = this.getXsrfToken();
        result = result * 59 + ($xsrfToken == null ? 43 : $xsrfToken.hashCode());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        String $requestOrigin = this.getRequestOrigin();
        result = result * 59 + ($requestOrigin == null ? 43 : $requestOrigin.hashCode());
        AuthenticationMethod $authenticationMethod = this.getAuthenticationMethod();
        result = result * 59 + ($authenticationMethod == null ? 43 : ((Object)((Object)$authenticationMethod)).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CumulocityOAuthCredentials(oAuthAccessToken=" + this.oAuthAccessToken + ", xsrfToken=" + this.getXsrfToken() + ", applicationKey=" + this.getApplicationKey() + ", requestOrigin=" + this.getRequestOrigin() + ")";
    }

    @Generated
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @Override
    @Generated
    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    @Override
    @Generated
    public String getApplicationKey() {
        return this.applicationKey;
    }

    @Override
    @Generated
    public void setRequestOrigin(String requestOrigin) {
        this.requestOrigin = requestOrigin;
    }

    @Override
    @Generated
    public String getRequestOrigin() {
        return this.requestOrigin;
    }

    @Generated
    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Override
    @Generated
    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public static class CumulocityOAuthCredentialsBuilder {
        @Generated
        private String oAuthAccessToken;
        @Generated
        private String xsrfToken;
        @Generated
        private String applicationKey;
        @Generated
        private String requestOrigin;
        @Generated
        private AuthenticationMethod authenticationMethod;
        @Generated
        private String tenantId;
        @Generated
        private String username;

        @Generated
        CumulocityOAuthCredentialsBuilder() {
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder oAuthAccessToken(String oAuthAccessToken) {
            this.oAuthAccessToken = oAuthAccessToken;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder xsrfToken(String xsrfToken) {
            this.xsrfToken = xsrfToken;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder requestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public CumulocityOAuthCredentials build() {
            return CumulocityOAuthCredentials.create(this.oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod, this.tenantId, this.username);
        }

        @Generated
        public String toString() {
            return "CumulocityOAuthCredentials.CumulocityOAuthCredentialsBuilder(oAuthAccessToken=" + this.oAuthAccessToken + ", xsrfToken=" + this.xsrfToken + ", applicationKey=" + this.applicationKey + ", requestOrigin=" + this.requestOrigin + ", authenticationMethod=" + this.authenticationMethod + ", tenantId=" + this.tenantId + ", username=" + this.username + ")";
        }
    }
}

