/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation.identity;

import com.cumulocity.rest.representation.identity.ExternalIDCollectionRepresentation;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.support.BDDJsonRepresentationTestBase;
import com.cumulocity.rest.representation.support.TestJsonProvider;
import java.util.List;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ExternalIDCollectionRepresentationTest
extends BDDJsonRepresentationTestBase<ExternalIDCollectionRepresentation> {
    ExternalIDCollectionRepresentationTest() {
    }

    @ParameterizedTest
    @EnumSource(value=TestJsonProvider.class)
    void shouldDeserializeToRepresentation(TestJsonProvider provider) {
        this.givenJsonString("{   \"externalIds\":[      {         \"externalId\":\"132458\",         \"type\":\"c8y_Serial\",         \"managedObject\":{            \"id\":\"55\"         }      },      {         \"externalId\":\"565484\",         \"type\":\"c8y_xtDevice\",         \"managedObject\":{            \"id\":\"88\"         }      }   ]}");
        this.whenDeserializedUsing(provider);
        this.thenReturnedExternalIdCollection().hasXtIdListOfSize(2).andTheList().extracting(ExternalIDRepresentation::getExternalId).contains((Object[])new String[]{"132458", "565484"});
    }

    private ExternalIdCollectionAssert thenReturnedExternalIdCollection() {
        return new ExternalIdCollectionAssert((ExternalIDCollectionRepresentation)this.getRepresentation());
    }

    private static final class ExternalIdCollectionAssert {
        private final ExternalIDCollectionRepresentation rep;

        public ExternalIdCollectionAssert hasXtIdListOfSize(int size) {
            Assertions.assertThat((List)this.rep.getExternalIds()).hasSize(size);
            return this;
        }

        public ListAssert<ExternalIDRepresentation> andTheList() {
            return Assertions.assertThat((List)this.rep.getExternalIds());
        }

        @Generated
        public ExternalIdCollectionAssert(ExternalIDCollectionRepresentation rep) {
            this.rep = rep;
        }

        @Generated
        public ExternalIDCollectionRepresentation getRep() {
            return this.rep;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalIdCollectionAssert)) {
                return false;
            }
            ExternalIdCollectionAssert other = (ExternalIdCollectionAssert)o;
            ExternalIDCollectionRepresentation this$rep = this.getRep();
            ExternalIDCollectionRepresentation other$rep = other.getRep();
            return !(this$rep == null ? other$rep != null : !this$rep.equals(other$rep));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExternalIDCollectionRepresentation $rep = this.getRep();
            result = result * 59 + ($rep == null ? 43 : $rep.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalIDCollectionRepresentationTest.ExternalIdCollectionAssert(rep=" + this.getRep() + ")";
        }
    }
}

