/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.SourceableConverter;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

class SourceableConverterTest {
    private SourceableConverter converter;

    SourceableConverterTest() {
    }

    @BeforeEach
    public void before() {
        this.converter = new SourceableConverter();
    }

    @Test
    public void shouldOptimizeSourceWhenContainsUnnecessaryFields() throws JSONException {
        String uselessFieldName = "uselessField";
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(GId.asGId((Long)1L));
        source.setName("someName");
        source.setSelf("http://c8y.com/inventory/managedObjects/1");
        source.set((Object)"uselessField", "someValue");
        ManagedObjectRepresentation result = (ManagedObjectRepresentation)this.converter.toJSON((Object)source);
        Assertions.assertNull((Object)result.get("uselessField"));
        JSONAssert.assertEquals((String)"{\"name\":\"someName\",\"self\":\"http://c8y.com/inventory/managedObjects/1\",\"id\":\"1\"}", (String)result.toJSON(), (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    public void shouldNotChangeRepresentationIfSourceContainsOnlyId() throws JSONException {
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(GId.asGId((String)"321"));
        String jsonBeforeOptimize = source.toJSON();
        ManagedObjectRepresentation result = (ManagedObjectRepresentation)this.converter.toJSON((Object)source);
        JSONAssert.assertEquals((String)jsonBeforeOptimize, (String)result.toJSON(), (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    public void shouldNotChangeObjectWhenIsNotInstanceOfManagedObjectRepresentation() {
        AlarmRepresentation alarmRepresentation = new AlarmRepresentation();
        alarmRepresentation.setText("exampleText");
        AlarmRepresentation result = (AlarmRepresentation)this.converter.toJSON((Object)alarmRepresentation);
        Assertions.assertEquals((Object)alarmRepresentation, (Object)result);
    }
}

