/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.authentication;

import com.cumulocity.model.authentication.CumulocityOAuthCredentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CumulocityOAuthCredentialsTest {
    private static final String SAMPLE_TOKEN = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOm51bGwsImlzcyI6Im9hdXRoLnN0YWdpbmctbGF0ZXN0LmM4eS5pbyIsImF1ZCI6Im9hdXRoLnN0YWdpbmctbGF0ZXN0LmM4eS5pbyIsInN1YiI6ImxhcmEiLCJpYXQiOjE1NDU5OTA5ODcsIm5iZiI6bnVsbCwiZXhwIjoxNTQ1OTk0NTg3LCJ0ZW4iOiJvYXV0aCIsInhzcmZUb2tlbiI6IlNKWlBJUlBORGJ3T1RmendqZFJkIn0.ZUkBibmqJftF1lSMtSLKAs_KQYJw3QbiplNdnyTrwyoASsFfKHja_ywHQnypWYDKGx062Uc8x6OkcoGefSgsZQ";
    private static final String TOKEN_WITHOUT_TENANT_CLAIM = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.KMUFsIDTnFmyG3nMiGM6H9FNFUROf3wh7SmqJp-QV30";

    @Test
    public void shouldReadTenantIdCorrectly() {
        CumulocityOAuthCredentials credentials = CumulocityOAuthCredentials.builder().oAuthAccessToken(SAMPLE_TOKEN).build();
        Assertions.assertEquals((Object)"oauth", (Object)credentials.getTenantId());
    }

    @Test
    public void shouldReadUsernameCorrectly() {
        CumulocityOAuthCredentials credentials = CumulocityOAuthCredentials.builder().oAuthAccessToken(SAMPLE_TOKEN).build();
        Assertions.assertEquals((Object)"lara", (Object)credentials.getUsername());
    }

    @Test
    public void shouldReturnAccessTokenAsAuthenticationString() {
        CumulocityOAuthCredentials credentials = CumulocityOAuthCredentials.builder().oAuthAccessToken(SAMPLE_TOKEN).build();
        Assertions.assertEquals((Object)SAMPLE_TOKEN, (Object)credentials.getAuthenticationString());
    }

    @Test
    public void shouldReturnTenantIdFromTokenWithoutTenantClaim() {
        CumulocityOAuthCredentials credentials = CumulocityOAuthCredentials.builder().tenantId("external-tenant").oAuthAccessToken(TOKEN_WITHOUT_TENANT_CLAIM).build();
        Assertions.assertEquals((Object)"external-tenant", (Object)credentials.getTenantId());
    }
}

