/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.authentication;

import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CumulocityBasicCredentialsTest {
    CumulocityBasicCredentialsTest() {
    }

    @Test
    void shouldReadFull() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"tenant/username:password:pass");
        Assertions.assertEquals((Object)"tenant", (Object)credentials.getTenantId());
        Assertions.assertEquals((Object)"username", (Object)credentials.getUsername());
        Assertions.assertEquals((Object)"password:pass", (Object)credentials.getPassword());
    }

    @Test
    void shouldReadTenantUsername() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"tenant/username");
        Assertions.assertEquals((Object)"tenant", (Object)credentials.getTenantId());
        Assertions.assertEquals((Object)"username", (Object)credentials.getUsername());
        Assertions.assertNull((Object)credentials.getPassword());
    }

    @Test
    void shouldReadUsername() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"username");
        Assertions.assertNull((Object)credentials.getTenantId());
        Assertions.assertEquals((Object)"username", (Object)credentials.getUsername());
        Assertions.assertNull((Object)credentials.getPassword());
    }

    @Test
    void shouldReadUsernamePassword() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"username:password:pass");
        Assertions.assertNull((Object)credentials.getTenantId());
        Assertions.assertEquals((Object)"username", (Object)credentials.getUsername());
        Assertions.assertEquals((Object)"password:pass", (Object)credentials.getPassword());
    }

    @Test
    void shouldReturnBasicEncodedAuthenticationString() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"username:password:pass");
        Assertions.assertEquals((Object)"Basic dXNlcm5hbWU6cGFzc3dvcmQ6cGFzcw==", (Object)credentials.getAuthenticationString());
    }

    @Test
    void shouldReturnBasicEncodedAuthenticationStringWithNoAsciiCharacters() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)"management/\u7530\u4e2d\u9686\u592a:(Def_Leppard)1");
        Assertions.assertEquals((Object)"Basic bWFuYWdlbWVudC/nlLDkuK3pmoblpKo6KERlZl9MZXBwYXJkKTE=", (Object)credentials.getAuthenticationString());
    }

    @Test
    void shouldHidePassword() {
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.builder().username("username").password("password").tenantId("tenId").applicationKey("appKey").requestOrigin("reqOrigin").build();
        Assertions.assertEquals((Object)"CumulocityBasicCredentials{username='username', tenantId='tenId', password='******', applicationKey='appKey', requestOrigin='reqOrigin'}", (Object)credentials.toString());
    }

    @Test
    void shouldCorrectlyParsePasswordWithSlashesAndColons() {
        String passwordWithSlashesAndColons = "/pa:ss/word/";
        String tenantLoginPassword = "tenantName/userName:" + passwordWithSlashesAndColons;
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)tenantLoginPassword);
        Assertions.assertEquals((Object)"tenantName/userName", (Object)credentials.getLoginWithTenant());
        Assertions.assertEquals((Object)credentials.getPassword(), (Object)passwordWithSlashesAndColons);
    }

    @Test
    void shouldCorrectlyParsePasswordWithSlashesWhenThereIsNoTenant() {
        String passwordWithSlashesAndColons = "/pa:ss/word/";
        String loginPasswordWithoutTenant = "userName:" + passwordWithSlashesAndColons;
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.from((String)loginPasswordWithoutTenant);
        Assertions.assertEquals((Object)"userName", (Object)credentials.getLoginWithTenant());
        Assertions.assertEquals((Object)credentials.getPassword(), (Object)passwordWithSlashesAndColons);
    }
}

