/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.JSONBase;
import com.cumulocity.model.utils.StringReader;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class JSONBaseTest {
    JSONBaseTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"/json/unknownSimpleField.json", "/json/unknownComplexField.json"})
    void shouldIgnoreUnknownFields(String resource) throws Exception {
        String json = StringReader.readResource(resource);
        TestModel testModel = (TestModel)JSONBase.fromJSON((String)json, TestModel.class);
        Assertions.assertThat((Object)testModel).isNotNull();
        Assertions.assertThat((Integer)testModel.getMeasurement()).isNotNull();
        Assertions.assertThat((String)testModel.getType()).isNotBlank();
    }

    @Test
    void shouldIgnoreUnknownFieldsInNestedStructure() throws Exception {
        String json = StringReader.readResource("/json/unknownComplexFieldInNestedStructure.json");
        TestModel testModel = (TestModel)JSONBase.fromJSON((String)json, TestModel.class);
        Assertions.assertThat((Object)testModel).isNotNull();
        Assertions.assertThat((Integer)testModel.getMeasurement()).isNotNull();
        Assertions.assertThat((String)testModel.getType()).isNotBlank();
        Assertions.assertThat((String)testModel.getDetails().getDescription()).isNotBlank();
    }

    public static class TestModel {
        private Integer measurement;
        private String type;
        private Details details;

        @Generated
        public TestModel() {
        }

        @Generated
        public Integer getMeasurement() {
            return this.measurement;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Details getDetails() {
            return this.details;
        }

        @Generated
        public void setMeasurement(Integer measurement) {
            this.measurement = measurement;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setDetails(Details details) {
            this.details = details;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestModel)) {
                return false;
            }
            TestModel other = (TestModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$measurement = this.getMeasurement();
            Integer other$measurement = other.getMeasurement();
            if (this$measurement == null ? other$measurement != null : !((Object)this$measurement).equals(other$measurement)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Details this$details = this.getDetails();
            Details other$details = other.getDetails();
            return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TestModel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $measurement = this.getMeasurement();
            result = result * 59 + ($measurement == null ? 43 : ((Object)$measurement).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Details $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JSONBaseTest.TestModel(measurement=" + this.getMeasurement() + ", type=" + this.getType() + ", details=" + this.getDetails() + ")";
        }
    }

    public static class Details {
        private String description;

        @Generated
        public Details() {
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Details)) {
                return false;
            }
            Details other = (Details)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Details;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JSONBaseTest.Details(description=" + this.getDescription() + ")";
        }
    }
}

