/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.DynamicPropertiesFilter;
import com.cumulocity.model.ID;
import com.cumulocity.model.IDTypeConverter;
import com.cumulocity.model.JSONBase;
import com.cumulocity.model.util.Classes;
import com.cumulocity.model.util.ExtensibilityConverter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.svenson.AbstractDynamicProperties;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public abstract class Document<T extends ID>
extends JSONBase {
    public static DynamicPropertiesFilter acceptAll = new DynamicPropertiesFilter(){

        @Override
        public boolean apply(String name) {
            return true;
        }
    };
    private T id;
    @Deprecated
    private String internalId;
    @Deprecated
    private String revision;

    public static <E extends AbstractDynamicProperties> E copyDynamicProperties(AbstractDynamicProperties source, E target, DynamicPropertiesFilter filter) {
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null!");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null!");
        }
        for (String name : source.propertyNames()) {
            if (!filter.apply(name)) continue;
            target.setProperty(name, source.getProperty(name));
        }
        return target;
    }

    public static <E extends AbstractDynamicProperties> E copyDynamicProperties(AbstractDynamicProperties source, E target) {
        return Document.copyDynamicProperties(source, target, acceptAll);
    }

    public static <E extends AbstractDynamicProperties> E deepCopyDynamicProperties(AbstractDynamicProperties source, E target) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"Source cannot be null!");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null!");
        for (String name : source.propertyNames()) {
            Object sourceValue = source.getProperty(name);
            if (sourceValue == null || Classes.isSimpleProperty(sourceValue.getClass())) {
                target.setProperty(name, sourceValue);
                continue;
            }
            target.setProperty(name, Document.getJSONParser().parse(Document.getJSONGenerator().forValue(sourceValue)));
        }
        return target;
    }

    protected Document() {
    }

    protected Document(T id) {
        this(id, (String)null);
    }

    protected Document(T id, Map<String, Object> fragments) {
        this(id, null, null, fragments);
    }

    protected Document(T id, String internalId) {
        this(id, internalId, null);
    }

    protected Document(T id, String internalId, String revision) {
        this(id, internalId, revision, null);
    }

    protected Document(T id, String internalId, String revision, Map<String, Object> fragments) {
        this.id = id;
        this.internalId = internalId;
        this.revision = revision;
        this.add(fragments);
    }

    @JSONProperty(value="id", ignoreIfNull=true)
    @JSONConverter(type=IDTypeConverter.class)
    public T getId() {
        return this.id;
    }

    public void setId(T id) {
        this.id = id;
    }

    @Deprecated
    @JSONProperty(value="_id", ignoreIfNull=true)
    public String getInternalId() {
        return this.internalId;
    }

    @Deprecated
    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    @Deprecated
    @JSONProperty(value="_rev", ignoreIfNull=true)
    public String getRevision() {
        return this.revision;
    }

    @Deprecated
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @JSONProperty(ignore=true)
    public void set(Object object) {
        this.set(object, object.getClass());
    }

    @JSONProperty(ignore=true)
    public void set(Object object, String propertyName) {
        this.setProperty(propertyName, object);
    }

    @JSONProperty(ignore=true)
    public <C> void set(Object object, Class<C> clazz) {
        this.setProperty(ExtensibilityConverter.classToStringRepresentation(clazz), object);
    }

    @JSONProperty(ignore=true)
    public void add(Map<String, Object> fragments) {
        if (fragments == null) {
            return;
        }
        for (Map.Entry<String, Object> fragment : fragments.entrySet()) {
            this.setProperty(fragment.getKey(), fragment.getValue());
        }
    }

    public <C> C get(Class<C> clazz) {
        Object property = this.getProperty(ExtensibilityConverter.classToStringRepresentation(clazz));
        return clazz.isInstance(property) ? (C)clazz.cast(property) : null;
    }

    public <C> C get(String propertyName, Class<C> asClass) {
        Object o = this.get(propertyName);
        if (o == null) {
            return null;
        }
        return this.readObject(o, asClass);
    }

    protected <C> C readObject(Object source, Class<C> asClass) {
        return Document.fromJSON(Document.getJSONGenerator().forValue(source), asClass);
    }

    public void remove(Class<?> clazz) {
        this.removeProperty(ExtensibilityConverter.classToStringRepresentation(clazz));
    }

    public Object get(String name) {
        return this.getProperty(name);
    }

    public Object getFragment(String name) {
        return this.get(name);
    }

    public int hashCode() {
        return this.getId() != null ? ((ID)((Object)this.getId())).hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)((Object)o);
        return !(this.getId() != null ? !((ID)((Object)this.getId())).equals(document.getId()) : document.getId() != null);
    }

    public String toString() {
        return this.toJSON();
    }

    public static <T extends ID> Function<? super Document<T>, T> asId() {
        return new Function<Document<T>, T>(){

            @Nullable
            public T apply(@Nullable Document<T> input) {
                return input.getId();
            }
        };
    }
}

