/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.util;

import com.cumulocity.model.DateTimeConverter;
import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    public static Chronology chronologyUTC() {
        return ISOChronology.getInstanceUTC();
    }

    public static Chronology chronologyLocal() {
        return ISOChronology.getInstance();
    }

    public static DateTime nowUTC() {
        return new DateTime(org.joda.time.DateTimeUtils.currentTimeMillis(), DateTimeUtils.chronologyUTC());
    }

    public static DateTime nowDateTimeLocal() {
        return new DateTime(org.joda.time.DateTimeUtils.currentTimeMillis(), DateTimeUtils.chronologyLocal());
    }

    public static DateTime convertNameToOffset(DateTime dateTime) {
        return DateTimeConverter.string2Date(DateTimeConverter.date2String(dateTime));
    }

    public static DateTime newUTC(long millis) {
        return new DateTime((Object)new Date(millis), DateTimeUtils.chronologyUTC());
    }

    public static DateTime newUTC(Date date) {
        return new DateTime((Object)date, DateTimeUtils.chronologyUTC());
    }

    public static DateTime newLocal(long millis) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)new Date(millis), DateTimeUtils.chronologyLocal()));
    }

    public static DateTime newLocal(Date date) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)date, DateTimeUtils.chronologyLocal()));
    }

    public static DateTime newLocal(Date date, int offsetInMillis) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)date, (Chronology)ISOChronology.getInstance((DateTimeZone)DateTimeZone.forOffsetMillis((int)offsetInMillis))));
    }
}

