/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.util;

import com.cumulocity.model.util.Alias;
import com.cumulocity.model.util.AliasMapClassFinder;
import com.cumulocity.model.util.ClassFinder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.annotation.Annotation;
import java.time.Duration;
import lombok.Generated;

public class ExtensibilityConverter {
    private final Cache<String, Class> foundClasses;
    private final Cache<Class, String> canonicalNames;
    private final ClassFinder classFinder;

    protected ExtensibilityConverter(Duration cacheTimeout, ClassFinder classFinder) {
        this.foundClasses = CacheBuilder.newBuilder().expireAfterAccess(cacheTimeout).build();
        this.canonicalNames = CacheBuilder.newBuilder().expireAfterAccess(cacheTimeout).build();
        this.classFinder = classFinder;
    }

    private static ExtensibilityConverter getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public static Class classFromExtensibilityString(String name) throws ClassNotFoundException {
        return ExtensibilityConverter.getInstance().classFromExtensibilityString2(name);
    }

    public static boolean isConvertable(String name) {
        return ExtensibilityConverter.getInstance().foundClasses.getIfPresent((Object)name) == null || ExtensibilityConverter.getInstance().foundClasses.getIfPresent((Object)name) != ExtensibilityMappingFailed.class;
    }

    protected Class classFromExtensibilityString2(String name) throws ClassNotFoundException {
        Class alreadyFoundClass = (Class)this.foundClasses.getIfPresent((Object)name);
        if (alreadyFoundClass != null) {
            if (alreadyFoundClass.equals(ExtensibilityMappingFailed.class)) {
                throw new ClassNotFoundException();
            }
            return alreadyFoundClass;
        }
        return this.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findClass(String name) throws ClassNotFoundException {
        Class foundClass = null;
        try {
            foundClass = this.classFinder.findClassByAlias(name);
            if (foundClass == null) {
                String className = name.replace('_', '.');
                foundClass = this.classFinder.findClassByClassName(className);
            }
        }
        finally {
            if (foundClass == null) {
                this.foundClasses.put((Object)name, ExtensibilityMappingFailed.class);
                throw new ClassNotFoundException();
            }
            this.foundClasses.put((Object)name, (Object)foundClass);
        }
        return foundClass;
    }

    public static <T> String classToStringRepresentation(Class<T> clazz) {
        return ExtensibilityConverter.getInstance().classToStringRepresentation2(clazz);
    }

    private <T> String classToStringRepresentation2(Class<T> clazz) {
        String alias = this.tryGetAlias(clazz);
        if (alias != null) {
            return alias;
        }
        String canonicalName = (String)this.canonicalNames.getIfPresent(clazz);
        if (canonicalName == null) {
            canonicalName = clazz.getCanonicalName().replace(".", "_").intern();
            this.canonicalNames.put(clazz, (Object)canonicalName);
        }
        return canonicalName;
    }

    private <T> String tryGetAlias(Class<T> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(Alias.class)) continue;
            return ((Alias)annotation).value();
        }
        return null;
    }

    @Generated
    protected Cache<String, Class> getFoundClasses() {
        return this.foundClasses;
    }

    private static class SingletonHelper {
        private static final ExtensibilityConverter INSTANCE = new ExtensibilityConverter(Duration.ofHours(12L), new AliasMapClassFinder());

        private SingletonHelper() {
        }
    }

    private class ExtensibilityMappingFailed {
        private ExtensibilityMappingFailed() {
        }
    }
}

