/*
 * Decompiled with CFR 0.152.
 */
package com.nsn.cumulocity.model.builder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractObjectBuilder<T> {
    protected final Map<String, Object> values = new LinkedHashMap<String, Object>();
    protected final Map<String, Collection<?>> collectionValues = new LinkedHashMap();
    protected final Map<String, AbstractObjectBuilder<?>> builders = new LinkedHashMap();
    protected final Map<String, List<AbstractObjectBuilder<?>>> collectionBuilders = new LinkedHashMap();
    private T domainObject = null;

    public synchronized T build() {
        if (this.domainObject == null) {
            this.domainObject = this.createDomainObject();
            this.fillInValues(this.domainObject);
            this.fillInBuilderValues(this.domainObject);
            this.fillInCollectionValues(this.domainObject);
            this.fillInCollectionBuilderValues(this.domainObject);
        }
        return this.domainObject;
    }

    protected abstract T createDomainObject();

    protected void setFieldValue(String fieldName, Object value) {
        this.values.put(fieldName, value);
        this.builders.remove(fieldName);
    }

    protected void setFieldValueBuilder(String fieldName, AbstractObjectBuilder<?> builder) {
        this.builders.put(fieldName, builder);
    }

    protected void fillInValues(T domainObject) {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            this.setFieldValue(domainObject, entry.getKey(), entry.getValue());
        }
    }

    protected void fillInBuilderValues(T domainObject) {
        for (Map.Entry<String, AbstractObjectBuilder<?>> entry : this.builders.entrySet()) {
            this.setFieldValue(domainObject, entry.getKey(), entry.getValue().build());
        }
    }

    protected void fillInCollectionValues(T domainObject) {
        for (Map.Entry<String, Collection<?>> entry : this.collectionValues.entrySet()) {
            Field field = ReflectionUtils.findField(domainObject.getClass(), (String)entry.getKey());
            Collection value = this.createListValue(field.getType(), entry.getValue());
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, domainObject, (Object)value);
        }
    }

    private Collection createListValue(Class<?> collectionType, Collection<?> valuesList) {
        Collection builtValues = this.newCollection(collectionType);
        builtValues.addAll(valuesList);
        return builtValues;
    }

    private void fillInCollectionBuilderValues(T domainObject) {
        for (Map.Entry<String, List<AbstractObjectBuilder<?>>> entry : this.collectionBuilders.entrySet()) {
            Field field = ReflectionUtils.findField(domainObject.getClass(), (String)entry.getKey());
            Collection value = this.createBuilderListValue(field.getType(), entry.getValue());
            ReflectionUtils.setField((Field)field, domainObject, (Object)value);
        }
    }

    private Collection createBuilderListValue(Class<?> collectionType, List<AbstractObjectBuilder<?>> builderList) {
        Collection builtValues = this.newCollection(collectionType);
        for (AbstractObjectBuilder<?> builder : builderList) {
            builtValues.add(builder.build());
        }
        return builtValues;
    }

    private Collection newCollection(Class<?> collectionType) {
        if (Set.class.isAssignableFrom(collectionType)) {
            return new HashSet();
        }
        if (List.class.isAssignableFrom(collectionType)) {
            return new ArrayList();
        }
        throw new IllegalArgumentException("Unknown collection type: " + collectionType + "!");
    }

    private void setFieldValue(Object target, String fieldName, Object value) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }
}

