/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.ClassNameMapper;
import com.cumulocity.model.idtype.GId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassNameMapperTest {
    @Test
    public void getTypeHintShouldReturnClass() {
        String parsePathInfo = "jsonPathPart.com_cumulocity_model_idtype_GId";
        Class<String> typeHint = String.class;
        ClassNameMapper cnm = new ClassNameMapper();
        Class clazz = cnm.getTypeHint(null, parsePathInfo, typeHint);
        Assertions.assertEquals(GId.class, (Object)clazz);
    }

    @Test
    public void getTypeHintShouldReturnOriginalTypeHintForUnknownClass() {
        String parsePathInfo = "jsonPathPart.some_unknown_class_GId";
        Class<String> typeHint = String.class;
        ClassNameMapper cnm = new ClassNameMapper();
        Class clazz = cnm.getTypeHint(null, parsePathInfo, typeHint);
        Assertions.assertEquals(String.class, (Object)clazz);
    }

    @Test
    public void getTypeHintShouldReturnOriginalTypeHintForMalformed() {
        String parsePathInfo = "jsonPathPart.com_cumulocity_model_idtype.Reference";
        Class<String> typeHint = String.class;
        ClassNameMapper cnm = new ClassNameMapper();
        Class clazz = cnm.getTypeHint(null, parsePathInfo, typeHint);
        Assertions.assertEquals(String.class, (Object)clazz);
    }
}

