/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.util;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.util.AliasMapClassFinder;
import com.cumulocity.model.util.ClassFinder;
import com.cumulocity.model.util.ExtensibilityConverter;
import com.cumulocity.model.util.SimpleBean;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExtensibilityConverterTest {
    public static final String SOME_UNKNOWN_CLASS_REFERENCE = "some_unknown_class_GId";

    @Test
    public void classFromExtensibilityStringShouldReturnClass() throws ClassNotFoundException {
        String name = "com_cumulocity_model_idtype_GId";
        Class clazz = ExtensibilityConverter.classFromExtensibilityString((String)name);
        org.junit.jupiter.api.Assertions.assertEquals(GId.class, (Object)clazz);
    }

    @Test
    public void classFromExtensibilityStringAliasShouldReturnClass() throws ClassNotFoundException {
        String name = "sb";
        AliasMapClassFinder aliasMapClassFinder = new AliasMapClassFinder();
        aliasMapClassFinder.alias2ClassName.put(name, SimpleBean.class.getName());
        ExtensibilityConverter converter = new ExtensibilityConverter(Duration.ofHours(12L), (ClassFinder)aliasMapClassFinder);
        Class clazz = converter.classFromExtensibilityString2(name);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, (Object)clazz);
    }

    @Test
    public void classToStringRepresentationReturnAlias() {
        String alias = ExtensibilityConverter.classToStringRepresentation(SimpleBean.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"sb", (Object)alias);
    }

    @Test
    public void shouldRaiseExceptionIfClassNotInClasspath() {
        Throwable catched = Assertions.catchThrowable(() -> ExtensibilityConverter.classFromExtensibilityString((String)SOME_UNKNOWN_CLASS_REFERENCE));
        Assertions.assertThat((Throwable)catched).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    public void shouldRaiseExceptionIfNameDoesNotContainUnderscore() {
        String name = "someNameWithoutUnderscores";
        Throwable catched = Assertions.catchThrowable(() -> ExtensibilityConverter.classFromExtensibilityString((String)name));
        Assertions.assertThat((Throwable)catched).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    public void shouldNotCallClassForNameSecondTimeSameNameIsPassedForFoundClass() throws Exception {
        String name = "java_lang_String";
        String convertedName = name.replace('_', '.');
        AliasMapClassFinder classFinder = (AliasMapClassFinder)Mockito.spy((Object)new AliasMapClassFinder());
        ExtensibilityConverter converter = new ExtensibilityConverter(Duration.ofHours(12L), (ClassFinder)classFinder);
        converter.classFromExtensibilityString2(name);
        converter.classFromExtensibilityString2(name);
        ((AliasMapClassFinder)Mockito.verify((Object)classFinder, (VerificationMode)Mockito.times((int)1))).findClassByAlias(name);
        ((AliasMapClassFinder)Mockito.verify((Object)classFinder, (VerificationMode)Mockito.times((int)1))).findClassByClassName(convertedName);
    }

    @Test
    public void shouldNotCallClassForNameSecondTimeSameNameIsPassedForNotFoundClass() throws Exception {
        String name = SOME_UNKNOWN_CLASS_REFERENCE;
        String convertedName = name.replace('_', '.');
        AliasMapClassFinder classFinder = (AliasMapClassFinder)Mockito.spy((Object)new AliasMapClassFinder());
        ExtensibilityConverter converter = new ExtensibilityConverter(Duration.ofHours(12L), (ClassFinder)classFinder);
        try {
            converter.classFromExtensibilityString2(name);
            Assertions.fail((String)"ClassNotFound expected");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            converter.classFromExtensibilityString2(name);
            Assertions.fail((String)"ClassNotFound expected");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ((AliasMapClassFinder)Mockito.verify((Object)classFinder, (VerificationMode)Mockito.times((int)1))).findClassByClassName(convertedName);
    }

    @Test
    void shouldInvalidateCacheAfterTimeout() throws Exception {
        String name = "com_cumulocity_model_idtype_GId";
        ExtensibilityConverter converter = new ExtensibilityConverter(Duration.ofMillis(50L), (ClassFinder)new AliasMapClassFinder());
        converter.classFromExtensibilityString2(name);
        Assertions.assertThat((Class)((Class)converter.getFoundClasses().getIfPresent((Object)name))).isNotNull();
        Thread.sleep(60L);
        Assertions.assertThat((Class)((Class)converter.getFoundClasses().getIfPresent((Object)name))).isNull();
    }
}

