/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.io;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import lombok.Generated;

public interface DisposableInputStreamSource {
    public void dispose() throws IOException;

    public InputStream getInputStream() throws IOException;

    public static class LazyInputStreamSource
    implements DisposableInputStreamSource {
        private final Supplier<InputStream> inputStreamSupplier;
        private InputStream inputStream;

        @Override
        public void dispose() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.dispose();
            this.inputStream = this.inputStreamSupplier.get();
            return this.inputStream;
        }

        @Generated
        public LazyInputStreamSource(Supplier<InputStream> inputStreamSupplier) {
            this.inputStreamSupplier = inputStreamSupplier;
        }
    }

    public static class DisposableResource
    implements DisposableInputStreamSource {
        private final ByteSource resource;

        @Override
        public void dispose() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.resource.openStream();
        }

        @Generated
        public DisposableResource(ByteSource resource) {
            this.resource = resource;
        }
    }
}

