/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.authentication;

import com.cumulocity.model.authentication.AuthenticationMethod;
import com.cumulocity.model.authentication.CumulocityCredentials;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;

public class CumulocityBasicCredentials
implements CumulocityCredentials {
    private static final String TENANT_USERNAME_SEPARATOR = "/";
    private static final String USERNAME_PASSWORD_SEPARATOR = ":";
    private String username;
    private String tenantId;
    private String password;
    private String applicationKey;
    private String requestOrigin;

    public static CumulocityBasicCredentials from(String loginString) {
        CumulocityBasicCredentialsBuilder builder = CumulocityBasicCredentials.builder();
        String[] tenantUsernamePasswordSplitted = CumulocityBasicCredentials.splitTenantUsernamePassword(loginString);
        builder.tenantId(tenantUsernamePasswordSplitted[0]);
        builder.username(tenantUsernamePasswordSplitted[1]);
        builder.password(tenantUsernamePasswordSplitted[2]);
        return builder.build();
    }

    private static String[] splitTenantUsernamePassword(String loginString) {
        String usernamePasswordString;
        String[] tenantUsernamePassword = new String[3];
        String[] tenantFromUsernameSplit = loginString.split(TENANT_USERNAME_SEPARATOR);
        if (CumulocityBasicCredentials.hasTenant(tenantFromUsernameSplit)) {
            tenantUsernamePassword[0] = tenantFromUsernameSplit[0];
            usernamePasswordString = loginString.substring(loginString.indexOf(TENANT_USERNAME_SEPARATOR) + 1);
        } else {
            usernamePasswordString = loginString;
        }
        String[] usernamePasswordSplitted = CumulocityBasicCredentials.splitUsernamePassword(usernamePasswordString);
        tenantUsernamePassword[1] = usernamePasswordSplitted[0];
        tenantUsernamePassword[2] = usernamePasswordSplitted[1];
        return tenantUsernamePassword;
    }

    private static boolean hasTenant(String[] tenantLoginSplit) {
        if (CumulocityBasicCredentials.hasNotTenantAndNotSlashesInPassword(tenantLoginSplit)) {
            return false;
        }
        String tenantIfProvided = tenantLoginSplit[0];
        boolean tenantWasProvided = !tenantIfProvided.contains(USERNAME_PASSWORD_SEPARATOR);
        return tenantWasProvided;
    }

    private static String[] splitUsernamePassword(String loginPassword) {
        String[] usernamePasswordSplitted = new String[2];
        String[] loginPasswordSplitted = loginPassword.split(USERNAME_PASSWORD_SEPARATOR);
        usernamePasswordSplitted[0] = loginPasswordSplitted[0];
        if (loginPasswordSplitted.length >= 2) {
            usernamePasswordSplitted[1] = loginPassword.substring(loginPassword.indexOf(USERNAME_PASSWORD_SEPARATOR) + 1);
        }
        return usernamePasswordSplitted;
    }

    private static boolean hasNotTenantAndNotSlashesInPassword(String[] tenantLoginSplit) {
        return tenantLoginSplit.length == 1;
    }

    public CumulocityBasicCredentials(String username, String tenantId, String password, String applicationKey, String requestOrigin) {
        this.username = username;
        this.tenantId = tenantId;
        this.password = password;
        this.applicationKey = applicationKey;
        this.requestOrigin = requestOrigin;
    }

    @Override
    public String getAuthenticationString() {
        return "Basic " + Base64.encodeBase64String((byte[])(this.getLoginWithTenant() + USERNAME_PASSWORD_SEPARATOR + this.password).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.HEADER;
    }

    @Override
    public CumulocityCredentials copy() {
        return CumulocityBasicCredentials.builder().tenantId(this.getTenantId()).username(this.getUsername()).password(this.getPassword()).requestOrigin(this.getRequestOrigin()).applicationKey(this.getApplicationKey()).build();
    }

    public String getLoginWithTenant() {
        return this.tenantId == null ? this.username : this.tenantId + TENANT_USERNAME_SEPARATOR + this.username;
    }

    @Override
    public <T> T accept(CumulocityCredentials.CumulocityCredentialsVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "CumulocityBasicCredentials{username='" + this.username + "', tenantId='" + this.tenantId + "', password='" + this.hidePassword() + "', applicationKey='" + this.applicationKey + "', requestOrigin='" + this.requestOrigin + "'}";
    }

    private String hidePassword() {
        return this.password != null ? "******" : null;
    }

    @Generated
    public static CumulocityBasicCredentialsBuilder builder() {
        return new CumulocityBasicCredentialsBuilder();
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getApplicationKey() {
        return this.applicationKey;
    }

    @Override
    @Generated
    public String getRequestOrigin() {
        return this.requestOrigin;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CumulocityBasicCredentials)) {
            return false;
        }
        CumulocityBasicCredentials other = (CumulocityBasicCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        String this$requestOrigin = this.getRequestOrigin();
        String other$requestOrigin = other.getRequestOrigin();
        return !(this$requestOrigin == null ? other$requestOrigin != null : !this$requestOrigin.equals(other$requestOrigin));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CumulocityBasicCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        String $requestOrigin = this.getRequestOrigin();
        result = result * 59 + ($requestOrigin == null ? 43 : $requestOrigin.hashCode());
        return result;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    @Override
    @Generated
    public void setRequestOrigin(String requestOrigin) {
        this.requestOrigin = requestOrigin;
    }

    @Generated
    public static class CumulocityBasicCredentialsBuilder {
        @Generated
        private String username;
        @Generated
        private String tenantId;
        @Generated
        private String password;
        @Generated
        private String applicationKey;
        @Generated
        private String requestOrigin;

        @Generated
        CumulocityBasicCredentialsBuilder() {
        }

        @Generated
        public CumulocityBasicCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public CumulocityBasicCredentialsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public CumulocityBasicCredentialsBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public CumulocityBasicCredentialsBuilder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        @Generated
        public CumulocityBasicCredentialsBuilder requestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
            return this;
        }

        @Generated
        public CumulocityBasicCredentials build() {
            return new CumulocityBasicCredentials(this.username, this.tenantId, this.password, this.applicationKey, this.requestOrigin);
        }

        @Generated
        public String toString() {
            return "CumulocityBasicCredentials.CumulocityBasicCredentialsBuilder(username=" + this.username + ", tenantId=" + this.tenantId + ", password=" + this.password + ", applicationKey=" + this.applicationKey + ", requestOrigin=" + this.requestOrigin + ")";
        }
    }
}

