/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.ClassNameMapper;
import com.cumulocity.model.DateConverter;
import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.IDListTypeConverter;
import com.cumulocity.model.IDTypeConverter;
import com.cumulocity.model.audit.AuditChangeValueConverter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.svenson.AbstractDynamicProperties;
import org.svenson.CompositeTypeMapper;
import org.svenson.JSON;
import org.svenson.JSONParser;
import org.svenson.JSONProperty;
import org.svenson.TypeMapper;
import org.svenson.converter.DefaultTypeConverterRepository;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.tokenize.JSONCharacterSource;
import org.svenson.util.ExceptionWrapper;

public class JSONBase
extends AbstractDynamicProperties {
    public static final String ID_TYPE_CONVERTER_NAME = "id-converter";

    public String toJSON() {
        return JSONBase.getJSONGenerator().forValue((Object)this);
    }

    public static <T> T fromJSON(String json, Class<T> type) {
        JSONParser parser = JSONBase.getJSONParser();
        return (T)parser.parse(type, json);
    }

    public static <T> T fromJSON(Reader json, Class<T> type) {
        JSONParser parser = JSONBase.getJSONParser();
        return (T)parser.parse(type, (JSONCharacterSource)new ReaderJSONCharacterSource(json));
    }

    @JSONProperty(ignore=true)
    private static List<TypeConverter> defaultTypeConverters() {
        ArrayList<TypeConverter> converters = new ArrayList<TypeConverter>();
        converters.add(new DateTimeConverter());
        converters.add(new IDListTypeConverter());
        converters.add(new DateConverter());
        converters.add(new AuditChangeValueConverter());
        return converters;
    }

    @JSONProperty(ignore=true)
    private static TypeMapper defaultTypeMapper() {
        return new ClassNameMapper();
    }

    @JSONProperty(ignore=true)
    public static JSON getJSONGenerator() {
        return JSONGeneratorBuilder.jsonGenerator().withDefaults().build();
    }

    @JSONProperty(ignore=true)
    public static JSON getJSONGeneratorWithUTF8Encoding() {
        return JSONGeneratorBuilder.jsonGenerator().withDefaults().escapeUnicodeChars(false).build();
    }

    @JSONProperty(ignore=true)
    public static JSONParser getJSONParser() {
        return JSONParserBuilder.jsonParser().withDefaults().build();
    }

    public static class ReaderJSONCharacterSource
    implements JSONCharacterSource {
        private final Reader json;
        private int index;

        public ReaderJSONCharacterSource(Reader json) {
            this.json = json;
            this.index = 0;
        }

        public int nextChar() {
            try {
                int result = this.json.read();
                ++this.index;
                return (char)result;
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((IOException)e);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public void destroy() {
            try {
                this.json.close();
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((IOException)e);
            }
        }
    }

    public static class JSONGeneratorBuilder {
        private DefaultTypeConverterRepository typeConverterRepository = new DefaultTypeConverterRepository();
        private Boolean escapeUnicodeChars;

        private JSONGeneratorBuilder() {
        }

        public static JSONGeneratorBuilder jsonGenerator() {
            return new JSONGeneratorBuilder();
        }

        public JSONGeneratorBuilder withDefaults() {
            this.typeConverters(JSONBase.defaultTypeConverters());
            this.typeConverter(JSONBase.ID_TYPE_CONVERTER_NAME, new IDTypeConverter());
            return this;
        }

        public JSONGeneratorBuilder escapeUnicodeChars(boolean value) {
            this.escapeUnicodeChars = value;
            return this;
        }

        public JSONGeneratorBuilder typeConverter(TypeConverter converter) {
            this.typeConverterRepository.addTypeConverter(converter);
            return this;
        }

        public JSONGeneratorBuilder typeConverter(String name, TypeConverter converter) {
            this.typeConverterRepository.addTypeConverter(name, converter);
            return this;
        }

        public JSON build() {
            JSON generator = new JSON();
            generator.setTypeConverterRepository((TypeConverterRepository)this.typeConverterRepository);
            generator.registerTypeConversion(DateTime.class, (TypeConverter)new DateTimeConverter());
            if (this.escapeUnicodeChars != null) {
                generator.setEscapeUnicodeChars(this.escapeUnicodeChars.booleanValue());
            }
            return generator;
        }

        public void typeConverters(List<TypeConverter> converters) {
            for (TypeConverter converter : converters) {
                this.typeConverterRepository.addTypeConverter(converter);
            }
        }
    }

    public static class JSONParserBuilder {
        private DefaultTypeConverterRepository typeConverterRepository = new DefaultTypeConverterRepository();
        private List<TypeMapper> typeMappers = new ArrayList<TypeMapper>();

        private JSONParserBuilder() {
        }

        public static JSONParserBuilder jsonParser() {
            return new JSONParserBuilder();
        }

        public JSONParserBuilder withDefaults() {
            this.typeConverters(JSONBase.defaultTypeConverters());
            this.typeConverter(JSONBase.ID_TYPE_CONVERTER_NAME, new IDTypeConverter());
            this.typeMappers.add(JSONBase.defaultTypeMapper());
            return this;
        }

        public JSONParserBuilder typeConverter(TypeConverter converter) {
            this.typeConverterRepository.addTypeConverter(converter);
            return this;
        }

        public JSONParserBuilder typeConverter(String name, TypeConverter converter) {
            this.typeConverterRepository.addTypeConverter(name, converter);
            return this;
        }

        public JSONParserBuilder typeMapper(TypeMapper mapper) {
            this.typeMappers.add(mapper);
            return this;
        }

        public JSONParser build() {
            JSONParser parser = new JSONParser();
            parser.setTypeConverterRepository(this.typeConverterRepository);
            this.buildTypeMapper(parser);
            return parser;
        }

        private void buildTypeMapper(JSONParser parser) {
            if (this.typeMappers.size() == 1) {
                parser.setTypeMapper(this.typeMappers.get(0));
            } else {
                CompositeTypeMapper compositeTypeMapper = new CompositeTypeMapper();
                compositeTypeMapper.setTypeMappers(this.typeMappers);
                parser.setTypeMapper((TypeMapper)compositeTypeMapper);
            }
        }

        public JSONParserBuilder typeConverters(List<TypeConverter> converters) {
            for (TypeConverter converter : converters) {
                this.typeConverterRepository.addTypeConverter(converter);
            }
            return this;
        }
    }
}

