/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.audit.AuditRecordRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RepresentationModelTest {
    private final String TYPE_ONE = "TYPE_ONE";
    private final String TYPE_TWO = "TYPE_TWO";

    @Test
    public void shouldAlarmRepresentationBeEqual() {
        AlarmRepresentation firstAlarmRepresentation = new AlarmRepresentation();
        AlarmRepresentation secondAlarmRepresentation = new AlarmRepresentation();
        boolean isAlarmRepresentationEquals = firstAlarmRepresentation.equals((Object)secondAlarmRepresentation);
        Assertions.assertThat((boolean)isAlarmRepresentationEquals).isTrue();
    }

    @Test
    public void shouldAuditRepresentationBeEqual() {
        AuditRecordRepresentation firstAuditRecordRepresentation = new AuditRecordRepresentation();
        AuditRecordRepresentation secondAuditRecordRepresentation = new AuditRecordRepresentation();
        boolean isAuditRecordRepresentationEquals = firstAuditRecordRepresentation.equals((Object)secondAuditRecordRepresentation);
        Assertions.assertThat((boolean)isAuditRecordRepresentationEquals).isTrue();
    }

    @Test
    public void shouldAlarmRepresentationBeEqualWhenSuperTypeEqual() {
        AlarmRepresentation firstAlarmRepresentation = new AlarmRepresentation();
        AlarmRepresentation secondAlarmRepresentation = new AlarmRepresentation();
        firstAlarmRepresentation.setType("TYPE_ONE");
        secondAlarmRepresentation.setType("TYPE_ONE");
        boolean isAlarmRepresentationEquals = firstAlarmRepresentation.equals((Object)secondAlarmRepresentation);
        Assertions.assertThat((boolean)isAlarmRepresentationEquals).isTrue();
    }

    @Test
    public void shouldAlarmRepresentationBeNotEqualWhenSuperTypeNotEqual() {
        AlarmRepresentation firstAlarmRepresentation = new AlarmRepresentation();
        AlarmRepresentation secondAlarmRepresentation = new AlarmRepresentation();
        firstAlarmRepresentation.setType("TYPE_ONE");
        secondAlarmRepresentation.setType("TYPE_TWO");
        boolean isAlarmRepresentationEquals = firstAlarmRepresentation.equals((Object)secondAlarmRepresentation);
        Assertions.assertThat((boolean)isAlarmRepresentationEquals).isFalse();
    }

    @Test
    public void shouldAuditRepresentationBeEqualWhenSuperTypeEqual() {
        AuditRecordRepresentation firstAuditRecordRepresentation = new AuditRecordRepresentation();
        AuditRecordRepresentation secondAuditRecordRepresentation = new AuditRecordRepresentation();
        firstAuditRecordRepresentation.setType("TYPE_ONE");
        secondAuditRecordRepresentation.setType("TYPE_ONE");
        boolean isAuditRecordRepresentationEquals = firstAuditRecordRepresentation.equals((Object)secondAuditRecordRepresentation);
        Assertions.assertThat((boolean)isAuditRecordRepresentationEquals).isTrue();
    }

    @Test
    public void shouldAuditRepresentationBeNotEqualWhenSuperTypeNotEqual() {
        AuditRecordRepresentation firstAuditRecordRepresentation = new AuditRecordRepresentation();
        AuditRecordRepresentation secondAuditRecordRepresentation = new AuditRecordRepresentation();
        firstAuditRecordRepresentation.setType("TYPE_ONE");
        secondAuditRecordRepresentation.setType("TYPE_TWO");
        boolean isAuditRecordRepresentationEquals = firstAuditRecordRepresentation.equals((Object)secondAuditRecordRepresentation);
        Assertions.assertThat((boolean)isAuditRecordRepresentationEquals).isFalse();
    }

    @Test
    public void alarmsWithSameSourceIdAreEqual() {
        AlarmRepresentation alarm1 = this.alarmWithSource(GId.asGId((String)"11"));
        AlarmRepresentation alarm2 = this.alarmWithSource(GId.asGId((String)"11"));
        Assertions.assertThat((Object)alarm1).isEqualTo((Object)alarm2);
    }

    @Test
    public void alarmsWithDifferentSourceIdAreNotEqual() {
        AlarmRepresentation alarm1 = this.alarmWithSource(GId.asGId((String)"11"));
        AlarmRepresentation alarm2 = this.alarmWithSource(GId.asGId((String)"22"));
        AlarmRepresentation alarm3 = new AlarmRepresentation();
        Assertions.assertThat((Object)alarm1).isNotEqualTo((Object)alarm2);
        Assertions.assertThat((Object)alarm1).isNotEqualTo((Object)alarm3);
        Assertions.assertThat((Object)alarm3).isNotEqualTo((Object)alarm2);
    }

    private AlarmRepresentation alarmWithSource(GId sourceId) {
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(sourceId);
        AlarmRepresentation alarm = new AlarmRepresentation();
        alarm.setSource(source);
        return alarm;
    }

    @Test
    public void auditsWithSameSourceIdAreEqual() {
        AuditRecordRepresentation audit1 = this.auditWithSource(GId.asGId((String)"11"));
        AuditRecordRepresentation audit2 = this.auditWithSource(GId.asGId((String)"11"));
        Assertions.assertThat((Object)audit1).isEqualTo((Object)audit2);
    }

    @Test
    public void auditsWithDifferentSourceIdAreNotEqual() {
        AuditRecordRepresentation audit1 = this.auditWithSource(GId.asGId((String)"11"));
        AuditRecordRepresentation audit2 = this.auditWithSource(GId.asGId((String)"22"));
        AuditRecordRepresentation audit3 = new AuditRecordRepresentation();
        Assertions.assertThat((Object)audit1).isNotEqualTo((Object)audit2);
        Assertions.assertThat((Object)audit1).isNotEqualTo((Object)audit3);
        Assertions.assertThat((Object)audit3).isNotEqualTo((Object)audit2);
    }

    private AuditRecordRepresentation auditWithSource(GId sourceId) {
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(sourceId);
        AuditRecordRepresentation audit = new AuditRecordRepresentation();
        audit.setSource(source);
        return audit;
    }
}

