/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.util.ExtensibilityConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.svenson.TypeMapper;
import org.svenson.tokenize.JSONTokenizer;

public class ClassNameMapper
implements TypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNameMapper.class);

    public Class getTypeHint(JSONTokenizer tokenizer, String parsePathInfo, Class typeHint) {
        int i = parsePathInfo.lastIndexOf(".");
        if (i >= 0) {
            String clazzPart = parsePathInfo.substring(i + 1);
            try {
                if (ExtensibilityConverter.isConvertable(clazzPart)) {
                    return ExtensibilityConverter.classFromExtensibilityString(clazzPart);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.trace("Class {} not found using {}. Using typeHint {}", new Object[]{clazzPart, Thread.currentThread().getContextClassLoader(), typeHint});
            }
        }
        return typeHint;
    }
}

