/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation;

import com.cumulocity.rest.representation.application.ManifestRepresentation;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManifestRepresentationTest {
    @Test
    public void shouldRemoveDuplicateEntriesFromImports() {
        ManifestRepresentation manifest = this.aManifestWithDuplicateImports();
        List uniqueImports = manifest.getUniqueImports();
        Assertions.assertThat((List)uniqueImports).doesNotHaveDuplicates();
    }

    @Test
    public void shouldReturnNullIfNoImports() {
        ManifestRepresentation manifest = new ManifestRepresentation();
        List uniqueImports = manifest.getUniqueImports();
        Assertions.assertThat((List)uniqueImports).isNull();
    }

    private ManifestRepresentation duplicateImports(ManifestRepresentation manifest) {
        ManifestRepresentation newRepresentation = new ManifestRepresentation();
        List imports = manifest.getImports();
        ArrayList<String> newImports = new ArrayList<String>();
        for (String imp : imports) {
            newImports.add(imp);
            newImports.add(imp);
        }
        newRepresentation.setImports(newImports);
        return newRepresentation;
    }

    private ManifestRepresentation aManifestWithDuplicateImports() {
        ManifestRepresentation manifest = new ManifestRepresentation();
        ArrayList<String> listImports = new ArrayList<String>();
        listImports.add("myplugin1");
        listImports.add("myplugin2");
        listImports.add("myplugin3");
        manifest.setImports(listImports);
        return this.duplicateImports(manifest);
    }
}

