/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.measurement;

import com.cumulocity.model.measurement.StateType;
import com.cumulocity.model.measurement.ValueType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.svenson.JSONProperty;

public class MeasurementValue
implements Serializable {
    private static final long serialVersionUID = 82786895631760488L;
    private BigDecimal value;
    private String unit;
    private ValueType type;
    private String quantity;
    private StateType state;

    public MeasurementValue() {
    }

    public MeasurementValue(String unit) {
        this.unit = unit;
    }

    public MeasurementValue(BigDecimal value, String unit) {
        this.value = value;
        this.unit = unit;
    }

    public MeasurementValue(BigDecimal value, String unit, ValueType type, String quantity, StateType state) {
        this.value = value;
        this.unit = unit;
        this.type = type;
        this.quantity = quantity;
        this.state = state;
    }

    @JSONProperty(ignoreIfNull=false)
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @JSONProperty(ignoreIfNull=false)
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @JSONProperty(ignoreIfNull=true)
    public ValueType getType() {
        return this.type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    @JSONProperty(ignoreIfNull=true)
    public StateType getState() {
        return this.state;
    }

    public void setState(StateType state) {
        this.state = state;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("value", this.value);
        result.put("unit", this.unit);
        this.putIfNotNull(result, "quantity", this.quantity);
        this.putIfNotNull(result, "type", this.toStringOrNull((Object)this.type));
        this.putIfNotNull(result, "state", this.toStringOrNull((Object)this.state));
        return result;
    }

    private void putIfNotNull(HashMap<String, Object> result, String key, Object value) {
        if (value != null) {
            result.put(key, value);
        }
    }

    private String toStringOrNull(Object object) {
        return object == null ? null : object.toString();
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.quantity != null ? this.quantity.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeasurementValue)) {
            return false;
        }
        MeasurementValue that = (MeasurementValue)o;
        if (this.quantity != null ? !this.quantity.equals(that.quantity) : that.quantity != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MeasurementValue [value=");
        builder.append(this.value);
        if (this.unit != null) {
            builder.append(", unit=");
            builder.append(this.unit);
        }
        if (this.type != null) {
            builder.append(", type=");
            builder.append((Object)this.type);
        }
        if (this.quantity != null) {
            builder.append(", quantity=");
            builder.append(this.quantity);
        }
        if (this.state != null) {
            builder.append(", state=");
            builder.append((Object)this.state);
        }
        builder.append("]");
        return builder.toString();
    }
}

