/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.authentication;

import com.cumulocity.model.authentication.AuthenticationMethod;
import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityOAuthCredentials;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CumulocityCredentialsFactory {
    private String tenant;
    private String username;
    private String password;
    private String oAuthAccessToken;
    private String xsrfToken;
    private String applicationKey;
    private String requestOrigin;
    private AuthenticationMethod authenticationMethod;

    public CumulocityCredentials getCredentials() {
        if (StringUtils.isNotEmpty((CharSequence)this.oAuthAccessToken)) {
            return CumulocityOAuthCredentials.builder().oAuthAccessToken(this.oAuthAccessToken).xsrfToken(this.xsrfToken).applicationKey(this.applicationKey).requestOrigin(this.requestOrigin).authenticationMethod(this.authenticationMethod != null ? this.authenticationMethod : (this.xsrfToken != null ? AuthenticationMethod.COOKIE : AuthenticationMethod.HEADER)).build();
        }
        return CumulocityBasicCredentials.builder().tenantId(this.tenant).username(this.username).password(this.password).applicationKey(this.applicationKey).requestOrigin(this.requestOrigin).build();
    }

    @Generated
    public CumulocityCredentialsFactory withTenant(String tenant) {
        return this.tenant == tenant ? this : new CumulocityCredentialsFactory(tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withUsername(String username) {
        return this.username == username ? this : new CumulocityCredentialsFactory(this.tenant, username, this.password, this.oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withPassword(String password) {
        return this.password == password ? this : new CumulocityCredentialsFactory(this.tenant, this.username, password, this.oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withOAuthAccessToken(String oAuthAccessToken) {
        return this.oAuthAccessToken == oAuthAccessToken ? this : new CumulocityCredentialsFactory(this.tenant, this.username, this.password, oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withXsrfToken(String xsrfToken) {
        return this.xsrfToken == xsrfToken ? this : new CumulocityCredentialsFactory(this.tenant, this.username, this.password, this.oAuthAccessToken, xsrfToken, this.applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withApplicationKey(String applicationKey) {
        return this.applicationKey == applicationKey ? this : new CumulocityCredentialsFactory(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, applicationKey, this.requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withRequestOrigin(String requestOrigin) {
        return this.requestOrigin == requestOrigin ? this : new CumulocityCredentialsFactory(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.applicationKey, requestOrigin, this.authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory withAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        return this.authenticationMethod == authenticationMethod ? this : new CumulocityCredentialsFactory(this.tenant, this.username, this.password, this.oAuthAccessToken, this.xsrfToken, this.applicationKey, this.requestOrigin, authenticationMethod);
    }

    @Generated
    public CumulocityCredentialsFactory() {
    }

    @Generated
    public CumulocityCredentialsFactory(String tenant, String username, String password, String oAuthAccessToken, String xsrfToken, String applicationKey, String requestOrigin, AuthenticationMethod authenticationMethod) {
        this.tenant = tenant;
        this.username = username;
        this.password = password;
        this.oAuthAccessToken = oAuthAccessToken;
        this.xsrfToken = xsrfToken;
        this.applicationKey = applicationKey;
        this.requestOrigin = requestOrigin;
        this.authenticationMethod = authenticationMethod;
    }
}

