/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.util.DateTimeUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.svenson.converter.TypeConverter;

public class DateTimeConverter
implements TypeConverter {
    protected static final DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser().withChronology(DateTimeUtils.chronologyUTC()).withOffsetParsed();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime().withOffsetParsed();

    public Object fromJSON(Object in) {
        if (null == in) {
            return null;
        }
        if (in instanceof String) {
            return DateTimeConverter.string2Date((String)in);
        }
        throw new IllegalArgumentException("Parameter must be a String, was a " + (null != in ? in.getClass().toString() : "null"));
    }

    public static DateTime string2Date(String in) {
        return parser.parseDateTime(in);
    }

    public Object toJSON(Object in) {
        if (null == in) {
            return null;
        }
        if (in instanceof DateTime) {
            return DateTimeConverter.date2String((DateTime)in);
        }
        throw new IllegalArgumentException(String.format("Parameter must be a %s, but was a %s!", DateTime.class, in.getClass()));
    }

    public static String date2String(DateTime in) {
        return DATE_TIME_FORMATTER.print((ReadableInstant)in);
    }
}

